/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime;

import io.mantisrx.common.codec.Codecs;
import io.mantisrx.runtime.KeyValueStageConfig;
import io.mantisrx.runtime.NettyCodec;
import io.mantisrx.runtime.StageConfig;
import io.mantisrx.runtime.computation.GroupComputation;
import io.mantisrx.runtime.parameter.ParameterDefinition;
import io.reactivex.netty.codec.Codec;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class GroupToGroup<K1, T, K2, R>
extends KeyValueStageConfig<T, K2, R> {
    private final GroupComputation<K1, T, K2, R> computation;
    private final long keyExpireTimeSeconds;

    GroupToGroup(GroupComputation<K1, T, K2, R> computation, Config<K1, T, K2, R> config, Codec<T> inputCodec) {
        this(computation, config, NettyCodec.fromNetty(inputCodec));
    }

    GroupToGroup(GroupComputation<K1, T, K2, R> computation, Config<K1, T, K2, R> config, io.mantisrx.common.codec.Codec<T> inputCodec) {
        this(computation, config, Codecs.string(), inputCodec);
    }

    GroupToGroup(GroupComputation<K1, T, K2, R> computation, Config<K1, T, K2, R> config, io.mantisrx.common.codec.Codec<K1> inputKeyCodec, io.mantisrx.common.codec.Codec<T> inputCodec) {
        super(((Config)config).description, inputKeyCodec, inputCodec, ((Config)config).keyCodec, ((Config)config).codec, ((Config)config).inputStrategy, ((Config)config).parameters);
        this.computation = computation;
        this.keyExpireTimeSeconds = ((Config)config).keyExpireTimeSeconds;
    }

    public GroupComputation<K1, T, K2, R> getComputation() {
        return this.computation;
    }

    public long getKeyExpireTimeSeconds() {
        return this.keyExpireTimeSeconds;
    }

    public static class Config<K1, T, K2, R> {
        private io.mantisrx.common.codec.Codec<R> codec;
        private io.mantisrx.common.codec.Codec<K2> keyCodec;
        private String description;
        private long keyExpireTimeSeconds = TimeUnit.HOURS.toSeconds(1L);
        private final StageConfig.INPUT_STRATEGY inputStrategy = StageConfig.INPUT_STRATEGY.SERIAL;
        private List<ParameterDefinition<?>> parameters = Collections.emptyList();

        public Config<K1, T, K2, R> codec(Codec<R> codec) {
            this.codec = NettyCodec.fromNetty(codec);
            return this;
        }

        public Config<K1, T, K2, R> codec(io.mantisrx.common.codec.Codec<R> codec) {
            this.codec = codec;
            return this;
        }

        public Config<K1, T, K2, R> keyCodec(io.mantisrx.common.codec.Codec<K2> keyCodec) {
            this.keyCodec = keyCodec;
            return this;
        }

        public Config<K1, T, K2, R> keyExpireTimeSeconds(long seconds) {
            this.keyExpireTimeSeconds = seconds;
            return this;
        }

        public Config<K1, T, K2, R> description(String description) {
            this.description = description;
            return this;
        }

        public io.mantisrx.common.codec.Codec<K2> getKeyCodec() {
            return this.keyCodec;
        }

        public io.mantisrx.common.codec.Codec<R> getCodec() {
            return this.codec;
        }

        public String getDescription() {
            return this.description;
        }

        public long getKeyExpireTimeSeconds() {
            return this.keyExpireTimeSeconds;
        }

        public StageConfig.INPUT_STRATEGY getInputStrategy() {
            return this.inputStrategy;
        }

        public Config<K1, T, K2, R> withParameters(List<ParameterDefinition<?>> params) {
            this.parameters = params;
            return this;
        }
    }
}

