/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.source.http;

import io.mantisrx.runtime.source.http.ClientResumePolicy;
import io.mantisrx.runtime.source.http.impl.ServerClientContext;
import java.util.concurrent.TimeUnit;
import mantis.io.reactivex.netty.protocol.http.client.HttpClientResponse;
import rx.Observable;
import rx.functions.Func0;

public class ClientResumePolicies {
    public static <R, E> ClientResumePolicy<R, E> maxRepeat(final int maxRepeat) {
        return new ClientResumePolicy<R, E>(){

            @Override
            public Observable<HttpClientResponse<E>> onError(ServerClientContext<R, E> clientContext, int attempts, Throwable error) {
                return this.getNewResponse(clientContext, attempts);
            }

            @Override
            public Observable<HttpClientResponse<E>> onCompleted(ServerClientContext<R, E> clientContext, int attempts) {
                return this.getNewResponse(clientContext, attempts);
            }

            private Observable<HttpClientResponse<E>> getNewResponse(ServerClientContext<R, E> clientContext, int attempts) {
                if (attempts <= maxRepeat) {
                    return clientContext.newResponse();
                }
                return null;
            }
        };
    }

    public static <R, E> ClientResumePolicy<R, E> noRepeat() {
        return new ClientResumePolicy<R, E>(){

            @Override
            public Observable<HttpClientResponse<E>> onError(ServerClientContext<R, E> clientContext, int attempts, Throwable error) {
                return null;
            }

            @Override
            public Observable<HttpClientResponse<E>> onCompleted(ServerClientContext<R, E> clientContext, int attempts) {
                return null;
            }
        };
    }

    public static <R, E> ClientResumePolicy<R, E> delayed(final Func0<Long> delayFunc, final TimeUnit unit) {
        return new ClientResumePolicy<R, E>(){

            @Override
            public Observable<HttpClientResponse<E>> onError(ServerClientContext<R, E> clientContext, int attempts, Throwable error) {
                return this.createDelayedResponse(clientContext);
            }

            @Override
            public Observable<HttpClientResponse<E>> onCompleted(ServerClientContext<R, E> clientContext, int attempts) {
                return this.createDelayedResponse(clientContext);
            }

            private Observable<HttpClientResponse<E>> createDelayedResponse(ServerClientContext<R, E> clientContext) {
                return clientContext.newResponse().delaySubscription(((Long)delayFunc.call()).longValue(), unit);
            }
        };
    }

    public static <R, E> ClientResumePolicy<R, E> maxRepeat(final ClientResumePolicy<R, E> policy, final int maxRepeat) {
        return new ClientResumePolicy<R, E>(){

            @Override
            public Observable<HttpClientResponse<E>> onError(ServerClientContext<R, E> clientContext, int attempts, Throwable error) {
                if (attempts <= maxRepeat) {
                    return policy.onError(clientContext, attempts, error);
                }
                return null;
            }

            @Override
            public Observable<HttpClientResponse<E>> onCompleted(ServerClientContext<R, E> clientContext, int attempts) {
                if (attempts <= maxRepeat) {
                    return policy.onCompleted(clientContext, attempts);
                }
                return null;
            }
        };
    }
}

