/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.source;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.subjects.BehaviorSubject;

public class Index {
    private static final Logger log = LoggerFactory.getLogger(Index.class);
    private final int workerIndex;
    private final BehaviorSubject<Integer> totalNumWorkersObservable;

    public Index(int offset, int total) {
        this.workerIndex = offset;
        this.totalNumWorkersObservable = BehaviorSubject.create((Object)total);
    }

    public Index(int offset, Observable<Integer> totalWorkerAtStageObservable) {
        this.workerIndex = offset;
        this.totalNumWorkersObservable = BehaviorSubject.create();
        totalWorkerAtStageObservable.subscribe(this.totalNumWorkersObservable);
    }

    public int getWorkerIndex() {
        return this.workerIndex;
    }

    public int getTotalNumWorkers() {
        Integer workerNum = (Integer)this.totalNumWorkersObservable.getValue();
        if (workerNum != null) {
            return workerNum;
        }
        log.info("totalNumWorkersObservable is not ready yet, waiting.");
        return (Integer)this.totalNumWorkersObservable.take(1).toBlocking().first();
    }

    public Observable<Integer> getTotalNumWorkersObservable() {
        return this.totalNumWorkersObservable;
    }

    public String toString() {
        return "InputQuota [offset=" + this.workerIndex + ", total=" + this.getTotalNumWorkers() + "]";
    }
}

