/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.source.http.impl;

import io.mantisrx.runtime.source.http.impl.ResumeOnErrorPolicy;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action0;
import rx.schedulers.Schedulers;
import rx.subscriptions.SerialSubscription;

public class OperatorResumeOnError<T>
implements Observable.Operator<T, T> {
    private static final Scheduler scheduler = Schedulers.trampoline();
    private final ResumeOnErrorPolicy<T> resumePolicy;
    private final int currentAttempts;

    private OperatorResumeOnError(int currentAttempts, ResumeOnErrorPolicy<T> resumePolicy) {
        this.currentAttempts = currentAttempts;
        this.resumePolicy = resumePolicy;
    }

    public OperatorResumeOnError(ResumeOnErrorPolicy<T> resumePolicy) {
        this(0, resumePolicy);
    }

    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        final SerialSubscription serialSubscription = new SerialSubscription();
        child.add((Subscription)serialSubscription);
        return new Subscriber<T>(child){
            private final Scheduler.Worker worker;
            {
                super(x0);
                this.worker = scheduler.createWorker();
            }

            public void onCompleted() {
                child.onCompleted();
            }

            public void onError(final Throwable e) {
                this.worker.schedule(new Action0(){

                    public void call() {
                        try {
                            int newAttempts = OperatorResumeOnError.this.currentAttempts + 1;
                            Observable resume = OperatorResumeOnError.this.resumePolicy.call(newAttempts, e);
                            if (resume == null) {
                                child.onError(e);
                            } else {
                                resume = resume.lift(new OperatorResumeOnError(newAttempts, OperatorResumeOnError.this.resumePolicy));
                                serialSubscription.set(resume.unsafeSubscribe(child));
                            }
                        }
                        catch (Throwable e2) {
                            child.onError(e2);
                        }
                    }
                });
            }

            public void onNext(T t) {
                child.onNext(t);
            }
        };
    }
}

