/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.parameter.type;

import io.mantisrx.runtime.parameter.ParameterDecoder;
import io.mantisrx.runtime.parameter.ParameterDefinition;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class EnumParameter<T extends Enum<T>>
extends ParameterDefinition.Builder<Enum<T>> {
    private final Class<T> clazz;

    public EnumParameter(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public ParameterDecoder<Enum<T>> decoder() {
        return value -> Enum.valueOf(this.clazz, value.trim());
    }

    @Override
    public String getTypeDescription() {
        List ts = Arrays.stream(this.clazz.getEnumConstants()).map(Enum::name).collect(Collectors.toList());
        return "One of (" + String.join((CharSequence)",", ts) + ")";
    }

    @Override
    public Class<Enum<T>> classType() {
        return null;
    }
}

