/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.command;

import io.mantisrx.runtime.Job;
import io.mantisrx.runtime.command.Command;
import io.mantisrx.runtime.command.CommandException;
import io.mantisrx.runtime.command.CreateJobDescriptorFile;
import io.mantisrx.runtime.command.CreateZipFile;
import io.mantisrx.runtime.command.ReadJobFromJar;
import io.mantisrx.runtime.command.ValidateJob;
import java.io.File;

public class LoadValidateCreate
implements Command {
    private final String jobJarFile;
    private final String artifactName;
    private final String version;
    private final String project;
    private final String outputLocation;

    public LoadValidateCreate(String jobJarFile, String artifactName, String version, String outputLocation, String project) {
        this.jobJarFile = jobJarFile;
        this.outputLocation = outputLocation;
        this.version = version;
        this.artifactName = artifactName;
        this.project = project;
    }

    public static void main(String[] args) throws CommandException {
        if (args.length < 4) {
            System.err.println("usage: jarFile name version outputLocation project");
            System.exit(1);
        }
        String jobJarFile = args[0];
        String name = args[1];
        String version = args[2];
        String outputLocation = args[3];
        new LoadValidateCreate(jobJarFile, name, version, outputLocation, name).execute();
    }

    @Override
    public void execute() throws CommandException {
        ReadJobFromJar readCommand = new ReadJobFromJar(this.jobJarFile);
        readCommand.execute();
        Job job = readCommand.getJob();
        new ValidateJob(job).execute();
        File jobDescriptor = new File(this.outputLocation + "/" + this.artifactName + "-" + this.version + ".json");
        new CreateJobDescriptorFile(job, jobDescriptor, this.version, this.project).execute();
        new CreateZipFile(new File(this.outputLocation + "/" + this.artifactName + "-" + this.version + ".mantis"), new File(this.jobJarFile), jobDescriptor).execute();
    }
}

