/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.core;

import io.mantisrx.common.codec.Codec;
import io.mantisrx.common.codec.Codecs;
import io.mantisrx.runtime.core.MantisGraph;
import java.io.Serializable;

class OperandNode<T> {
    private final int nodeIdx;
    private final String description;
    private final Codec<Serializable> codec;

    public OperandNode(int i, String description) {
        this.nodeIdx = i;
        this.description = description;
        this.codec = Codecs.javaSerializer();
    }

    public static <T> OperandNode<T> create(MantisGraph graph, String description) {
        return new OperandNode<T>(graph.nodes().size(), description);
    }

    public String toString() {
        return String.format("%d (%s)", this.nodeIdx, this.description);
    }

    public <K extends Serializable> Codec<K> getKeyCodec() {
        return Codecs.javaSerializer();
    }

    public int getNodeIdx() {
        return this.nodeIdx;
    }

    public String getDescription() {
        return this.description;
    }

    public Codec<Serializable> getCodec() {
        return this.codec;
    }
}

