/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.parameter;

import io.mantisrx.runtime.Context;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import io.mantisrx.shaded.com.fasterxml.jackson.core.type.TypeReference;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceJobParameters {
    public static final String MANTIS_SOURCEJOB_TARGET_KEY = "target";
    public static final String MANTIS_SOURCEJOB_NAME_PARAM = "sourceJobName";
    public static final String MANTIS_SOURCEJOB_CRITERION = "criterion";
    public static final String MANTIS_SOURCEJOB_CLIENT_ID = "clientId";
    public static final String MANTIS_SOURCEJOB_IS_BROADCAST_MODE = "isBroadcastMode";
    private static final Logger log = LoggerFactory.getLogger(SourceJobParameters.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public static List<TargetInfo> parseInputParameters(Context ctx) {
        String targetListStr = (String)ctx.getParameters().get(MANTIS_SOURCEJOB_TARGET_KEY, "{}");
        return SourceJobParameters.parseTargetInfo(targetListStr);
    }

    public static List<TargetInfo> parseTargetInfo(String targetListStr) {
        ArrayList<TargetInfo> targetList = new ArrayList<TargetInfo>();
        try {
            Map targets = (Map)mapper.readValue(targetListStr, (TypeReference)new TypeReference<Map<String, List<TargetInfo>>>(){});
            if (targets.get("targets") != null) {
                return (List)targets.get("targets");
            }
        }
        catch (Exception ex) {
            log.error("Failed to parse target list: {}", (Object)targetListStr, (Object)ex);
        }
        return targetList;
    }

    public static List<TargetInfo> enforceClientIdConsistency(List<TargetInfo> targets, String defaultClientId) {
        targets.sort(Comparator.comparing(t -> t.criterion));
        HashSet<AbstractMap.SimpleEntry<String, String>> connectionPairs = new HashSet<AbstractMap.SimpleEntry<String, String>>(targets.size());
        for (TargetInfo target : targets) {
            if (target.clientId == null) {
                target.clientId = defaultClientId;
            }
            AbstractMap.SimpleEntry<String, String> connectionPair = new AbstractMap.SimpleEntry<String, String>(target.sourceJobName, target.clientId);
            int attempts = 0;
            while (connectionPairs.contains(connectionPair)) {
                connectionPair = new AbstractMap.SimpleEntry<String, String>(target.sourceJobName, target.clientId + "_" + ++attempts);
            }
            target.clientId = (String)connectionPair.getValue();
            connectionPairs.add(connectionPair);
        }
        return targets;
    }

    public static class TargetInfoBuilder {
        private String sourceJobName;
        private String criterion;
        private String clientId;
        private int samplePerSec = -1;
        private boolean isBroadcastMode = false;
        private boolean enableMetaMessages = false;
        private boolean enableCompressedBinary = false;
        private String delimiter = null;

        public TargetInfoBuilder withSourceJobName(String srcJobName) {
            this.sourceJobName = srcJobName;
            return this;
        }

        public TargetInfoBuilder withQuery(String query) {
            this.criterion = query;
            return this;
        }

        public TargetInfoBuilder withSamplePerSec(int samplePerSec) {
            this.samplePerSec = samplePerSec;
            return this;
        }

        public TargetInfoBuilder withBroadCastMode() {
            this.isBroadcastMode = true;
            return this;
        }

        public TargetInfoBuilder withMetaMessagesEnabled() {
            this.enableMetaMessages = true;
            return this;
        }

        public TargetInfoBuilder withBinaryCompressionEnabled() {
            this.enableCompressedBinary = true;
            return this;
        }

        public TargetInfoBuilder withClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public TargetInfoBuilder withDelimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public TargetInfo build() {
            return new TargetInfo(this.sourceJobName, this.criterion, this.clientId, this.samplePerSec, this.isBroadcastMode, this.enableMetaMessages, this.enableCompressedBinary, this.delimiter);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TargetInfo {
        @JsonProperty(value="sourceJobName")
        public String sourceJobName;
        @JsonProperty(value="criterion")
        public String criterion;
        @JsonProperty(value="clientId")
        public String clientId;
        @JsonProperty(value="sample")
        public int samplePerSec = -1;
        @JsonProperty(value="isBroadcastMode")
        public boolean isBroadcastMode;
        @JsonProperty(value="enableMetaMessages")
        public boolean enableMetaMessages;
        @JsonProperty(value="mantis.EnableCompressedBinary")
        public boolean enableCompressedBinary;
        @JsonProperty(value="mantis.CompressionDelimiter")
        public String delimiter;

        public TargetInfo(String jobName, String criterion, String clientId, int samplePerSec, boolean isBroadcastMode, boolean enableMetaMessages, boolean enableCompressedBinary, String delimiter) {
            this.sourceJobName = jobName;
            this.criterion = criterion;
            this.clientId = clientId;
            this.samplePerSec = samplePerSec;
            this.isBroadcastMode = isBroadcastMode;
            this.enableMetaMessages = enableMetaMessages;
            this.enableCompressedBinary = enableCompressedBinary;
            this.delimiter = delimiter;
        }

        public TargetInfo() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TargetInfo that = (TargetInfo)o;
            return Objects.equals(this.sourceJobName, that.sourceJobName) && Objects.equals(this.criterion, that.criterion) && Objects.equals(this.clientId, that.clientId) && Objects.equals(this.samplePerSec, that.samplePerSec) && Objects.equals(this.isBroadcastMode, that.isBroadcastMode) && Objects.equals(this.enableMetaMessages, that.enableMetaMessages) && Objects.equals(this.enableCompressedBinary, that.enableCompressedBinary) && Objects.equals(this.delimiter, that.delimiter);
        }

        public int hashCode() {
            return Objects.hash(this.sourceJobName, this.criterion, this.clientId, this.samplePerSec, this.isBroadcastMode, this.enableMetaMessages, this.enableCompressedBinary, this.delimiter);
        }

        public String toString() {
            return "TargetInfo{sourceJobName=" + this.sourceJobName + ",criterion=" + this.criterion + ",clientId=" + this.clientId + ",samplePerSec=" + this.samplePerSec + ",isBroadcastMode=" + this.isBroadcastMode + ",enableMetaMessages=" + this.enableMetaMessages + ",enableCompressedBinary=" + this.enableCompressedBinary + ",delimiter=" + this.delimiter + ",}";
        }
    }
}

