/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.source.http.impl;

import io.mantisrx.runtime.source.http.HttpClientFactory;
import io.netty.buffer.ByteBuf;
import mantis.io.reactivex.netty.RxNetty;
import mantis.io.reactivex.netty.client.RxClient;
import mantis.io.reactivex.netty.pipeline.PipelineConfigurators;
import mantis.io.reactivex.netty.protocol.http.client.HttpClient;
import mantis.io.reactivex.netty.protocol.http.client.HttpClientBuilder;
import mantis.io.reactivex.netty.protocol.http.sse.ServerSentEvent;

public class HttpClientFactories {
    public static HttpClientFactory<ByteBuf, ByteBuf> defaultFactory() {
        return new DefaultHttpClientFactory();
    }

    public static HttpClientFactory<ByteBuf, ByteBuf> defaultFactory(boolean enableConnectionPooling, boolean enableIdleConnectionCleanup) {
        return new DefaultHttpClientFactory(enableConnectionPooling, enableIdleConnectionCleanup);
    }

    public static HttpClientFactory<ByteBuf, ServerSentEvent> sseClientFactory() {
        return new SSEClientFactory();
    }

    @Deprecated
    public static HttpClientFactory<ByteBuf, ServerSentEvent> sseClientFactory(int readTimeout) {
        return new SSEClientFactory(readTimeout);
    }

    public static HttpClientFactory<ByteBuf, ServerSentEvent> sseClientFactory(boolean enableConnectionPooling, boolean enableIdleConnectionCleanup) {
        return new SSEClientFactory(enableConnectionPooling, enableIdleConnectionCleanup);
    }

    private static class SSEClientFactory
    implements HttpClientFactory<ByteBuf, ServerSentEvent> {
        private final boolean enableConnectionPooling;
        private final boolean enableIdleConnectionCleanup;

        public SSEClientFactory(boolean enableConnectionPooling, boolean enableIdleConnectionCleanup) {
            this.enableConnectionPooling = enableConnectionPooling;
            this.enableIdleConnectionCleanup = enableIdleConnectionCleanup;
        }

        public SSEClientFactory(int readTimeout) {
            this();
        }

        public SSEClientFactory() {
            this(false, false);
        }

        @Override
        public HttpClient<ByteBuf, ServerSentEvent> createClient(RxClient.ServerInfo server) {
            HttpClientBuilder builder = (HttpClientBuilder)RxNetty.newHttpClientBuilder((String)server.getHost(), (int)server.getPort()).pipelineConfigurator(PipelineConfigurators.clientSseConfigurator());
            if (!this.enableConnectionPooling) {
                builder.withNoConnectionPooling();
            } else if (!this.enableIdleConnectionCleanup) {
                builder.withNoIdleConnectionCleanup();
            }
            return (HttpClient)builder.build();
        }
    }

    private static class DefaultHttpClientFactory
    implements HttpClientFactory<ByteBuf, ByteBuf> {
        private final RxClient.ClientConfig clientConfig;
        private final boolean enableConnectionPooling;
        private final boolean enableIdleConnectionCleanup;

        public DefaultHttpClientFactory() {
            this(false, false);
        }

        public DefaultHttpClientFactory(boolean enableConnectionPooling, boolean enableIdleConnectionCleanup) {
            this.enableConnectionPooling = enableConnectionPooling;
            this.enableIdleConnectionCleanup = enableIdleConnectionCleanup;
            this.clientConfig = new HttpClient.HttpClientConfig.Builder().setFollowRedirect(true).userAgent("Netflix Mantis HTTP Source").build();
        }

        @Override
        public HttpClient<ByteBuf, ByteBuf> createClient(RxClient.ServerInfo server) {
            HttpClientBuilder builder = (HttpClientBuilder)new HttpClientBuilder(server.getHost(), server.getPort()).config(this.clientConfig);
            if (!this.enableConnectionPooling) {
                builder.withNoConnectionPooling();
            } else if (!this.enableIdleConnectionCleanup) {
                builder.withNoIdleConnectionCleanup();
            }
            return (HttpClient)builder.build();
        }
    }
}

