/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.command;

import io.mantisrx.runtime.Job;
import io.mantisrx.runtime.MantisJobProvider;
import io.mantisrx.runtime.command.Command;
import io.mantisrx.runtime.command.CommandException;
import io.mantisrx.runtime.command.ReadJobFromJarException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.ServiceLoader;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ReadJobFromJar
implements Command {
    private String jobJarFile;
    private Job job;

    public ReadJobFromJar(String jobJarFile) {
        this.jobJarFile = jobJarFile;
    }

    public Job getJob() {
        return this.job;
    }

    @Override
    public void execute() throws CommandException {
        try {
            JarFile jf = new JarFile(this.jobJarFile);
            Enumeration<JarEntry> en = jf.entries();
            String serviceFile = "META-INF/services/io.mantisrx.runtime.MantisJobProvider";
            boolean serviceFileFound = false;
            while (en.hasMoreElements()) {
                JarEntry entry = en.nextElement();
                if (!serviceFile.equals(entry.getName())) continue;
                serviceFileFound = true;
            }
            jf.close();
            if (!serviceFileFound) {
                throw new ReadJobFromJarException("Service file not found in jar at location: META-INF/services/io.mantisrx.runtime.MantisJobProvider");
            }
            URLClassLoader cl = URLClassLoader.newInstance(new URL[]{new URL("file://" + this.jobJarFile)}, Thread.currentThread().getContextClassLoader());
            int providerCount = 0;
            ServiceLoader<MantisJobProvider> provider = ServiceLoader.load(MantisJobProvider.class, cl);
            for (MantisJobProvider jobProvider : provider) {
                this.job = jobProvider.getJobInstance();
                ++providerCount;
            }
            if (providerCount != 1) {
                throw new ReadJobFromJarException("Provider count not equal to 1 for MantisJobProvider, count: " + providerCount + ".  Either no entry exists in META-INF/services/io.mantisrx.runtime.MantisJobProvider, or more than one entry exists.");
            }
        }
        catch (MalformedURLException e) {
            throw new ReadJobFromJarException(e);
        }
        catch (IOException e) {
            throw new ReadJobFromJarException(e);
        }
    }
}

