/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.command;

import io.mantisrx.runtime.Job;
import io.mantisrx.runtime.command.Command;
import io.mantisrx.runtime.command.CommandException;
import io.mantisrx.runtime.command.CreateJobDescriptorFile;
import io.mantisrx.runtime.command.ReadJobFromZip;
import io.mantisrx.runtime.command.ValidateJob;
import java.io.File;

public class LoadValidateCreateZip
implements Command {
    private final String jobZipFile;
    private final String artifactName;
    private final String version;
    private final String outputLocation;
    private final boolean readyForJobMaster;

    public LoadValidateCreateZip(String jobZipFile, String artifactName, String version, String outputLocation, boolean readyForJobMaster) {
        this.jobZipFile = jobZipFile;
        this.outputLocation = outputLocation;
        this.version = version;
        this.artifactName = artifactName;
        this.readyForJobMaster = readyForJobMaster;
    }

    public static void main(String[] args) throws CommandException {
        if (args.length < 4) {
            System.err.println("usage: zipFile artifactName version outputLocation");
            System.exit(1);
        }
        String jobZipFile = args[0];
        String name = args[1];
        String version = args[2];
        String outputLocation = args[3];
        boolean readyForJobMaster = false;
        if (args.length == 5) {
            readyForJobMaster = Boolean.valueOf(args[4]);
        }
        new LoadValidateCreateZip(jobZipFile, name, version, outputLocation, readyForJobMaster).execute();
    }

    @Override
    public void execute() throws CommandException {
        ReadJobFromZip readCommand = new ReadJobFromZip(this.jobZipFile, this.artifactName, this.version);
        readCommand.execute();
        Job job = readCommand.getJob();
        new ValidateJob(job).execute();
        File jobDescriptor = new File(this.outputLocation + "/" + this.artifactName + "-" + this.version + ".json");
        new CreateJobDescriptorFile(job, jobDescriptor, this.version, this.artifactName, this.readyForJobMaster).execute();
    }
}

