/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.command;

import io.mantisrx.runtime.Job;
import io.mantisrx.runtime.command.Command;
import io.mantisrx.runtime.command.CommandException;
import io.mantisrx.runtime.command.CreateJobDescriptorFile;
import io.mantisrx.runtime.command.ReadJobFromJar;
import io.mantisrx.runtime.command.ValidateJob;
import java.io.File;

public class LoadValidateCreateDir
implements Command {
    private String jarPath;

    public LoadValidateCreateDir(String jarPath) {
        this.jarPath = jarPath;
    }

    public static void main(String[] args) throws CommandException {
        if (args.length < 1) {
            System.err.println("usage: directory to scan");
            System.exit(1);
        }
        String classpath = System.getProperty("java.class.path");
        System.out.println(classpath);
        String jarPath = args[0];
        new LoadValidateCreateDir(jarPath).execute();
        System.exit(0);
    }

    @Override
    public void execute() throws CommandException {
        File dir = new File(this.jarPath);
        File[] directoryListing = dir.listFiles();
        if (directoryListing != null) {
            for (File child : directoryListing) {
                System.out.println("================================");
                System.out.println("Absolute Path:" + child.getAbsolutePath());
                System.out.println("File name only:" + child.getName());
                File fileLoop = new File(child.getAbsolutePath());
                System.out.println("Dirname: " + fileLoop.getParent());
                System.out.println("Basename: " + fileLoop.getName());
                String fileBase = fileLoop.getName().substring(0, fileLoop.getName().lastIndexOf("."));
                String fileExtension = fileLoop.getName().substring(fileLoop.getName().lastIndexOf(".") + 1, fileLoop.getName().length());
                String jsonFile = fileBase + ".json";
                String fileVersion = fileLoop.getName().substring(fileLoop.getName().lastIndexOf("-") + 1, fileLoop.getName().lastIndexOf("."));
                System.out.println("fileBase: " + fileBase);
                System.out.println("fileExtension: " + fileExtension);
                System.out.println("jsonFile: " + jsonFile);
                System.out.println("fileVersion: " + fileVersion);
                try {
                    ReadJobFromJar readCommand = new ReadJobFromJar(child.getAbsolutePath());
                    readCommand.execute();
                    Job job = readCommand.getJob();
                    new ValidateJob(job).execute();
                    File jobDescriptor = new File(fileLoop.getParent() + "/" + jsonFile);
                    new CreateJobDescriptorFile(job, jobDescriptor, fileVersion, fileBase).execute();
                }
                catch (Exception e) {
                    System.out.println("Got an error " + e.toString());
                    System.exit(1);
                }
                System.out.println("================================");
            }
        } else {
            System.out.println("not a dir");
            System.exit(1);
        }
    }
}

