/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime;

import io.mantisrx.common.metrics.MetricsRegistry;
import io.mantisrx.runtime.WorkerInfo;
import io.mantisrx.runtime.WorkerMap;
import io.mantisrx.runtime.lifecycle.LifecycleNoOp;
import io.mantisrx.runtime.lifecycle.ServiceLocator;
import io.mantisrx.runtime.parameter.Parameters;
import rx.Observable;
import rx.functions.Action0;
import rx.subjects.BehaviorSubject;

public class Context {
    private final Action0 completeAndExitAction;
    private MetricsRegistry metricsRegistry;
    private Parameters parameters = new Parameters();
    private ServiceLocator serviceLocator = new LifecycleNoOp().getServiceLocator();
    private WorkerInfo workerInfo;
    private Observable<Boolean> prevStageCompletedObservable = BehaviorSubject.create((Object)false);
    private Observable<WorkerMap> workerMapObservable = Observable.empty();

    public Context() {
        this.completeAndExitAction = () -> {};
    }

    public Context(Parameters parameters, ServiceLocator serviceLocator, WorkerInfo workerInfo, MetricsRegistry metricsRegistry, Action0 completeAndExitAction) {
        this(parameters, serviceLocator, workerInfo, metricsRegistry, completeAndExitAction, (Observable<WorkerMap>)Observable.empty());
    }

    public Context(Parameters parameters, ServiceLocator serviceLocator, WorkerInfo workerInfo, MetricsRegistry metricsRegistry, Action0 completeAndExitAction, Observable<WorkerMap> workerMapObservable) {
        this.parameters = parameters;
        this.serviceLocator = serviceLocator;
        this.workerInfo = workerInfo;
        this.metricsRegistry = metricsRegistry;
        if (completeAndExitAction == null) {
            throw new IllegalArgumentException("Null complete action provided in Context contructor");
        }
        this.completeAndExitAction = completeAndExitAction;
        this.workerMapObservable = workerMapObservable;
    }

    public MetricsRegistry getMetricsRegistry() {
        return this.metricsRegistry;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public ServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    public String getJobId() {
        return this.workerInfo.getJobId();
    }

    public WorkerInfo getWorkerInfo() {
        return this.workerInfo;
    }

    @Deprecated
    public Observable<Boolean> getPrevStageCompletedObservable() {
        return this.prevStageCompletedObservable;
    }

    @Deprecated
    public void setPrevStageCompletedObservable(Observable<Boolean> prevStageCompletedObservable) {
        this.prevStageCompletedObservable = prevStageCompletedObservable;
    }

    public void completeAndExit() {
        this.completeAndExitAction.call();
    }

    public Observable<WorkerMap> getWorkerMapObservable() {
        return this.workerMapObservable;
    }
}

