/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.core;

import io.mantisrx.runtime.core.KeyedMantisStream;
import io.mantisrx.runtime.core.MantisGraph;
import io.mantisrx.runtime.core.MantisStream;
import io.mantisrx.runtime.core.MantisStreamImpl;
import io.mantisrx.runtime.core.OperandNode;
import io.mantisrx.runtime.core.WindowSpec;
import io.mantisrx.runtime.core.functions.FilterFunction;
import io.mantisrx.runtime.core.functions.FlatMapFunction;
import io.mantisrx.runtime.core.functions.MantisFunction;
import io.mantisrx.runtime.core.functions.MapFunction;
import io.mantisrx.runtime.core.functions.ReduceFunction;
import io.mantisrx.runtime.core.functions.WindowFunction;

class KeyedMantisStreamImpl<K, T>
implements KeyedMantisStream<K, T> {
    final OperandNode<T> currNode;
    final MantisGraph graph;

    public KeyedMantisStreamImpl(OperandNode<T> node, MantisGraph graph) {
        this.currNode = node;
        this.graph = graph;
    }

    <OUT> KeyedMantisStream<K, OUT> updateGraph(MantisFunction mantisFn) {
        OperandNode node = OperandNode.create(this.graph, mantisFn.getClass().getName() + "OUT");
        this.graph.putEdge(this.currNode, node, mantisFn);
        return new KeyedMantisStreamImpl(node, this.graph);
    }

    @Override
    public <OUT> KeyedMantisStream<K, OUT> map(MapFunction<T, OUT> mapFn) {
        return this.updateGraph(mapFn);
    }

    @Override
    public <OUT> KeyedMantisStream<K, OUT> flatMap(FlatMapFunction<T, OUT> flatMapFn) {
        return this.updateGraph(flatMapFn);
    }

    @Override
    public KeyedMantisStream<K, T> filter(FilterFunction<T> filterFn) {
        return this.updateGraph(filterFn);
    }

    @Override
    public KeyedMantisStream<K, T> window(WindowSpec spec) {
        this.graph.putEdge(this.currNode, this.currNode, new WindowFunction(spec));
        return new KeyedMantisStreamImpl<K, T>(this.currNode, this.graph);
    }

    @Override
    public <OUT> MantisStream<OUT> reduce(ReduceFunction<T, OUT> reduceFn) {
        OperandNode node = OperandNode.create(this.graph, "reduceFunctionOut");
        this.graph.putEdge(this.currNode, node, reduceFn);
        this.graph.putEdge(node, node, MantisFunction.empty());
        return new MantisStreamImpl(node, this.graph);
    }
}

