/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.source.http.impl;

import io.mantisrx.runtime.source.http.HttpRequestFactory;
import io.netty.buffer.ByteBuf;
import mantis.io.reactivex.netty.protocol.http.client.HttpClientRequest;

public class HttpRequestFactories {
    public static HttpRequestFactory<ByteBuf> createGetFactory(String uri) {
        return new GetRequestFactory(uri);
    }

    public static HttpRequestFactory<ByteBuf> createPostFactory(String uri) {
        return new SimplePostRequestFactory(uri);
    }

    public static HttpRequestFactory<ByteBuf> createPostFactory(String uri, byte[] entity) {
        return new PostRequestWithContentFactory(uri, entity);
    }

    private static class PostRequestWithContentFactory
    implements HttpRequestFactory<ByteBuf> {
        private final String uri;
        private final byte[] content;

        private PostRequestWithContentFactory(String uri, byte[] content) {
            this.uri = uri;
            this.content = content;
        }

        @Override
        public HttpClientRequest<ByteBuf> create() {
            return HttpClientRequest.createPost((String)this.uri).withContent(this.content);
        }
    }

    private static class SimplePostRequestFactory
    implements HttpRequestFactory<ByteBuf> {
        private final String uri;

        private SimplePostRequestFactory(String uri) {
            this.uri = uri;
        }

        @Override
        public HttpClientRequest<ByteBuf> create() {
            return HttpClientRequest.createPost((String)this.uri);
        }
    }

    private static class GetRequestFactory
    implements HttpRequestFactory<ByteBuf> {
        private final String uri;

        private GetRequestFactory(String uri) {
            this.uri = uri;
        }

        @Override
        public HttpClientRequest<ByteBuf> create() {
            return HttpClientRequest.createGet((String)this.uri);
        }
    }
}

