/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime;

import io.mantisrx.common.codec.Codec;
import io.mantisrx.runtime.parameter.ParameterDefinition;
import java.util.Collections;
import java.util.List;

public abstract class StageConfig<T, R> {
    public static final int DEFAULT_STAGE_CONCURRENCY = -1;
    private String description;
    private Codec<T> inputCodec;
    private Codec<R> outputCodec;
    private INPUT_STRATEGY inputStrategy;
    private List<ParameterDefinition<?>> parameters;
    private int concurrency = -1;

    public StageConfig(String description, Codec<T> inputCodec, Codec<R> outputCodec, INPUT_STRATEGY inputStrategy) {
        this(description, inputCodec, outputCodec, inputStrategy, Collections.emptyList(), -1);
    }

    public StageConfig(String description, Codec<T> inputCodec, Codec<R> outputCodec, INPUT_STRATEGY inputStrategy, List<ParameterDefinition<?>> params) {
        this(description, inputCodec, outputCodec, inputStrategy, params, -1);
    }

    public StageConfig(String description, Codec<T> inputCodec, Codec<R> outputCodec, INPUT_STRATEGY inputStrategy, int concurrency) {
        this(description, inputCodec, outputCodec, inputStrategy, Collections.emptyList(), concurrency);
    }

    public StageConfig(String description, Codec<T> inputCodec, Codec<R> outputCodec, INPUT_STRATEGY inputStrategy, List<ParameterDefinition<?>> params, int concurrency) {
        this.description = description;
        this.inputCodec = inputCodec;
        this.outputCodec = outputCodec;
        this.inputStrategy = inputStrategy;
        this.parameters = params;
        this.concurrency = concurrency;
    }

    public String getDescription() {
        return this.description;
    }

    public Codec<T> getInputCodec() {
        return this.inputCodec;
    }

    public Codec<R> getOutputCodec() {
        return this.outputCodec;
    }

    public INPUT_STRATEGY getInputStrategy() {
        return this.inputStrategy;
    }

    public List<ParameterDefinition<?>> getParameters() {
        return this.parameters;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public static enum INPUT_STRATEGY {
        NONE_SPECIFIED,
        SERIAL,
        CONCURRENT;

    }
}

