/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.parameter;

import io.mantisrx.runtime.parameter.ParameterException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Parameters {
    private Set<String> requiredParameters = new HashSet<String>();
    private Set<String> parameterDefinitions = new HashSet<String>();
    private Map<String, Object> state = new HashMap<String, Object>();

    public Parameters() {
    }

    public Parameters(Map<String, Object> state, Set<String> requiredParameters, Set<String> parameterDefinitions) {
        this.state = state;
        this.requiredParameters = requiredParameters;
        this.parameterDefinitions = parameterDefinitions;
    }

    public Object get(String key) {
        if (this.requiredParameters.contains(key) && !this.state.containsKey(key)) {
            throw new ParameterException("Attempting to reference a required parameter witn no value: " + key + ", check parameter definitions for job.");
        }
        if (!this.parameterDefinitions.contains(key)) {
            throw new ParameterException("Attempting to reference parameter: " + key + ", with no definition, check parameter definitions in job.");
        }
        return this.state.get(key);
    }

    public Object get(String key, Object defaultValue) {
        Object value = defaultValue;
        try {
            value = this.get(key);
            if (value == null) {
                value = defaultValue;
            }
        }
        catch (ParameterException ex) {
            value = defaultValue;
        }
        return value;
    }
}

