/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.source.http;

import io.mantisrx.runtime.source.http.ClientResumePolicy;
import io.mantisrx.runtime.source.http.ContextualHttpSource;
import io.mantisrx.runtime.source.http.HttpClientFactory;
import io.mantisrx.runtime.source.http.HttpRequestFactory;
import io.mantisrx.runtime.source.http.HttpServerProvider;
import io.mantisrx.runtime.source.http.HttpSource;
import io.mantisrx.runtime.source.http.impl.HttpClientFactories;
import io.mantisrx.runtime.source.http.impl.HttpRequestFactories;
import io.mantisrx.runtime.source.http.impl.HttpSourceImpl;
import io.mantisrx.runtime.source.http.impl.ServerClientContext;
import io.mantisrx.runtime.source.http.impl.ServerContext;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import mantis.io.reactivex.netty.client.RxClient;
import mantis.io.reactivex.netty.protocol.http.client.HttpClientResponse;
import rx.Observable;
import rx.functions.Func2;

public class HttpSources {
    public static <E> HttpSource.Builder<E, E> source(HttpClientFactory<ByteBuf, E> clientFactory, HttpRequestFactory<ByteBuf> requestFactory) {
        return HttpSource.builder(clientFactory, requestFactory);
    }

    public static <E> HttpSource.Builder<E, E> sourceWithResume(HttpClientFactory<ByteBuf, E> clientFactory, HttpRequestFactory<ByteBuf> requestFactory, ClientResumePolicy<ByteBuf, E> policy) {
        return HttpSource.builder(clientFactory, requestFactory, policy);
    }

    public static <E> ContextualHttpSource.Builder<E> contextualSource(HttpClientFactory<ByteBuf, E> clientFactory, HttpRequestFactory<ByteBuf> requestFactory) {
        return ContextualHttpSource.builder(clientFactory, requestFactory);
    }

    public static <E> ContextualHttpSource.Builder<E> contextualSourceWithResume(HttpClientFactory<ByteBuf, E> clientFactory, HttpRequestFactory<ByteBuf> requestFactory, ClientResumePolicy<ByteBuf, E> policy) {
        return ContextualHttpSource.builder(clientFactory, requestFactory, policy);
    }

    public static HttpSource.Builder<ByteBuf, String> pollingSource(final String host, final int port, String uri) {
        HttpClientFactory<ByteBuf, ByteBuf> clientFactory = HttpClientFactories.defaultFactory();
        HttpSourceImpl.Builder<ByteBuf, ByteBuf, String> builderImpl = HttpSourceImpl.builder(clientFactory, HttpRequestFactories.createGetFactory(uri), new Func2<ServerContext<HttpClientResponse<ByteBuf>>, ByteBuf, String>(){

            public String call(ServerContext<HttpClientResponse<ByteBuf>> context, ByteBuf content) {
                return content.toString(Charset.defaultCharset());
            }
        }).withServerProvider(new HttpServerProvider(){

            @Override
            public Observable<RxClient.ServerInfo> getServersToAdd() {
                return Observable.just((Object)new RxClient.ServerInfo(host, port));
            }

            @Override
            public Observable<RxClient.ServerInfo> getServersToRemove() {
                return Observable.empty();
            }
        }).resumeWith(new ClientResumePolicy<ByteBuf, ByteBuf>(){

            @Override
            public Observable<HttpClientResponse<ByteBuf>> onError(ServerClientContext<ByteBuf, ByteBuf> clientContext, int attempts, Throwable error) {
                return clientContext.newResponse();
            }

            @Override
            public Observable<HttpClientResponse<ByteBuf>> onCompleted(ServerClientContext<ByteBuf, ByteBuf> clientContext, int attempts) {
                return clientContext.newResponse();
            }
        });
        return HttpSource.builder(builderImpl);
    }
}

