/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.command;

import io.mantisrx.runtime.command.Command;
import io.mantisrx.runtime.command.CommandException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class CreateZipFile
implements Command {
    private File jobJarFile;
    private File jobDescriptor;
    private File zipfileName;

    public CreateZipFile(File zipfileName, File jobJarFile, File jobDescriptor) {
        this.zipfileName = zipfileName;
        this.jobJarFile = jobJarFile;
        this.jobDescriptor = jobDescriptor;
    }

    private void readBytesFromFile(File file, ZipOutputStream os) throws CommandException {
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(Files.newInputStream(Paths.get(file.toURI()), new OpenOption[0]));
            byte[] in = new byte[1024];
            int bytesRead = -1;
            while ((bytesRead = is.read(in)) > 0) {
                os.write(in, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new CommandException((Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new CommandException((Throwable)e);
            }
        }
    }

    @Override
    public void execute() throws CommandException {
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.zipfileName)));
            ZipEntry jobJarEntry = new ZipEntry(this.jobJarFile.getName());
            out.putNextEntry(jobJarEntry);
            this.readBytesFromFile(this.jobJarFile, out);
            out.closeEntry();
            ZipEntry jobDescriptorEntry = new ZipEntry(this.jobDescriptor.getName());
            out.putNextEntry(jobDescriptorEntry);
            this.readBytesFromFile(this.jobDescriptor, out);
            out.closeEntry();
        }
        catch (IOException e) {
            throw new CommandException((Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new CommandException((Throwable)e);
                }
            }
        }
    }
}

