/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime;

import io.mantisrx.runtime.StageConfig;
import io.mantisrx.runtime.computation.GroupToScalarComputation;
import io.mantisrx.runtime.parameter.ParameterDefinition;
import io.reactivex.netty.codec.Codec;
import java.util.Collections;
import java.util.List;

public class GroupToScalar<K, T, R>
extends StageConfig<T, R> {
    private GroupToScalarComputation<K, T, R> computation;
    private long keyExpireTimeSeconds;

    GroupToScalar(GroupToScalarComputation<K, T, R> computation, Config<K, T, R> config, final Codec<T> inputCodec) {
        super(((Config)config).description, new io.mantisrx.common.codec.Codec<T>(){

            public T decode(byte[] bytes) {
                return inputCodec.decode(bytes);
            }

            public byte[] encode(T value) {
                return inputCodec.encode(value);
            }
        }, ((Config)config).codec, ((Config)config).inputStrategy, ((Config)config).parameters);
        this.computation = computation;
        this.keyExpireTimeSeconds = ((Config)config).keyExpireTimeSeconds;
    }

    GroupToScalar(GroupToScalarComputation<K, T, R> computation, Config<K, T, R> config, io.mantisrx.common.codec.Codec<T> inputCodec) {
        super(((Config)config).description, inputCodec, ((Config)config).codec, ((Config)config).inputStrategy, ((Config)config).parameters);
        this.computation = computation;
        this.keyExpireTimeSeconds = ((Config)config).keyExpireTimeSeconds;
    }

    public GroupToScalarComputation<K, T, R> getComputation() {
        return this.computation;
    }

    public long getKeyExpireTimeSeconds() {
        return this.keyExpireTimeSeconds;
    }

    public static class Config<K, T, R> {
        private io.mantisrx.common.codec.Codec<R> codec;
        private String description;
        private long keyExpireTimeSeconds = 3600L;
        private StageConfig.INPUT_STRATEGY inputStrategy = StageConfig.INPUT_STRATEGY.SERIAL;
        private List<ParameterDefinition<?>> parameters = Collections.emptyList();

        public Config<K, T, R> codec(final Codec<R> codec) {
            this.codec = new io.mantisrx.common.codec.Codec<R>(){

                public R decode(byte[] bytes) {
                    return codec.decode(bytes);
                }

                public byte[] encode(R value) {
                    return codec.encode(value);
                }
            };
            return this;
        }

        public Config<K, T, R> codec(io.mantisrx.common.codec.Codec<R> codec) {
            this.codec = codec;
            return this;
        }

        public Config<K, T, R> keyExpireTimeSeconds(long seconds) {
            this.keyExpireTimeSeconds = seconds;
            return this;
        }

        public Config<K, T, R> description(String description) {
            this.description = description;
            return this;
        }

        public Config<K, T, R> concurrentInput() {
            this.inputStrategy = StageConfig.INPUT_STRATEGY.CONCURRENT;
            return this;
        }

        public io.mantisrx.common.codec.Codec<R> getCodec() {
            return this.codec;
        }

        public String getDescription() {
            return this.description;
        }

        public long getKeyExpireTimeSeconds() {
            return this.keyExpireTimeSeconds;
        }

        public StageConfig.INPUT_STRATEGY getInputStrategy() {
            return this.inputStrategy;
        }

        public Config<K, T, R> withParameters(List<ParameterDefinition<?>> params) {
            this.parameters = params;
            return this;
        }
    }
}

