/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.source.http.impl;

import io.mantisrx.runtime.source.http.impl.ResumeOnCompletedPolicy;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action0;
import rx.schedulers.Schedulers;
import rx.subscriptions.SerialSubscription;

public class OperatorResumeOnCompleted<T>
implements Observable.Operator<T, T> {
    private static Scheduler scheduler = Schedulers.trampoline();
    private final ResumeOnCompletedPolicy<T> resumePolicy;
    private final int currentAttempts;

    private OperatorResumeOnCompleted(int currentAttempts, ResumeOnCompletedPolicy<T> resumePolicy) {
        this.currentAttempts = currentAttempts;
        this.resumePolicy = resumePolicy;
    }

    public OperatorResumeOnCompleted(ResumeOnCompletedPolicy<T> resumePolicy) {
        this(0, resumePolicy);
    }

    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        final SerialSubscription serialSubscription = new SerialSubscription();
        child.add((Subscription)serialSubscription);
        return new Subscriber<T>(child){
            private final Scheduler.Worker worker;
            {
                super(x0);
                this.worker = scheduler.createWorker();
            }

            public void onCompleted() {
                this.worker.schedule(new Action0(){

                    public void call() {
                        try {
                            int newAttempts = OperatorResumeOnCompleted.this.currentAttempts + 1;
                            Observable resume = OperatorResumeOnCompleted.this.resumePolicy.call(newAttempts);
                            if (resume == null) {
                                child.onCompleted();
                            } else {
                                resume = resume.lift(new OperatorResumeOnCompleted(newAttempts, OperatorResumeOnCompleted.this.resumePolicy));
                                serialSubscription.set(resume.unsafeSubscribe(child));
                            }
                        }
                        catch (Throwable e2) {
                            child.onError(e2);
                        }
                    }
                });
            }

            public void onError(Throwable e) {
                child.onError(e);
            }

            public void onNext(T t) {
                child.onNext(t);
            }
        };
    }
}

