/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.loader.config;

import io.mantisrx.common.metrics.MetricsPublisher;
import io.mantisrx.runtime.loader.config.MetricsCollector;
import io.mantisrx.runtime.loader.config.WorkerConfiguration;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import java.io.File;
import java.net.URI;

public class WorkerConfigurationWritable
implements WorkerConfiguration {
    int mesosSlavePort;
    int zkConnectionTimeoutMs;
    int zkConnectionRetrySleepMs;
    int zkConnectionMaxRetries;
    String zkConnectionString;
    String leaderAnnouncementPath;
    String zkRoot;
    boolean isLocalMode;
    int metricsPublisherFrequencyInSeconds;
    String taskExecutorId;
    String clusterId;
    int metricsPort;
    int debugPort;
    int consolePort;
    int customPort;
    int sinkPort;
    int heartbeatInternalInMs;
    int tolerableConsecutiveHeartbeatFailures;
    int heartbeatTimeoutMs;
    long heartbeatRetryInitialDelayMs;
    long heartbeatRetryMaxDelayMs;
    long registrationRetryInitialDelayMillis;
    double registrationRetryMultiplier;
    double registrationRetryRandomizationFactor;
    int registrationRetryMaxAttempts;
    String externalAddress;
    String externalPortRange;
    String bindAddress;
    Integer bindPort;
    URI blobStoreArtifactDir;
    File localStorageDir;
    Double cpuCores;
    Double memoryInMB;
    Double diskInMB;
    double networkBandwidthInMB;
    String taskExecutorAttributesStr;
    int asyncHttpClientMaxConnectionsPerHost;
    int asyncHttpClientConnectionTimeoutMs;
    int asyncHttpClientRequestTimeoutMs;
    int asyncHttpClientReadTimeoutMs;
    @JsonIgnore
    MetricsPublisher metricsPublisher;
    @JsonIgnore
    MetricsCollector metricsCollector;

    public int getZkConnectionTimeoutMs() {
        return this.zkConnectionTimeoutMs;
    }

    public int getZkConnectionRetrySleepMs() {
        return this.zkConnectionRetrySleepMs;
    }

    public int getZkConnectionMaxRetries() {
        return this.zkConnectionMaxRetries;
    }

    public String getZkConnectionString() {
        return this.zkConnectionString;
    }

    public String getLeaderAnnouncementPath() {
        return this.leaderAnnouncementPath;
    }

    public String getZkRoot() {
        return this.zkRoot;
    }

    public boolean isLocalMode() {
        return this.isLocalMode;
    }

    public MetricsPublisher getMetricsPublisher() {
        return this.metricsPublisher;
    }

    public int getMetricsPublisherFrequencyInSeconds() {
        return this.metricsPublisherFrequencyInSeconds;
    }

    @Override
    public int getMesosSlavePort() {
        return this.mesosSlavePort;
    }

    @Override
    public String getTaskExecutorId() {
        return this.taskExecutorId;
    }

    @Override
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    public int getMetricsPort() {
        return this.metricsPort;
    }

    @Override
    public int getDebugPort() {
        return this.debugPort;
    }

    @Override
    public int getConsolePort() {
        return this.consolePort;
    }

    @Override
    public int getCustomPort() {
        return this.customPort;
    }

    @Override
    public int getSinkPort() {
        return this.sinkPort;
    }

    @Override
    public int heartbeatInternalInMs() {
        return this.heartbeatInternalInMs;
    }

    @Override
    public int getTolerableConsecutiveHeartbeatFailures() {
        return this.tolerableConsecutiveHeartbeatFailures;
    }

    @Override
    public int heartbeatTimeoutMs() {
        return this.heartbeatTimeoutMs;
    }

    @Override
    public long heartbeatRetryInitialDelayMs() {
        return this.heartbeatRetryInitialDelayMs;
    }

    @Override
    public long heartbeatRetryMaxDelayMs() {
        return this.heartbeatRetryMaxDelayMs;
    }

    @Override
    public long registrationRetryInitialDelayMillis() {
        return this.registrationRetryInitialDelayMillis;
    }

    @Override
    public double registrationRetryMultiplier() {
        return this.registrationRetryMultiplier;
    }

    @Override
    public double registrationRetryRandomizationFactor() {
        return this.registrationRetryRandomizationFactor;
    }

    @Override
    public int registrationRetryMaxAttempts() {
        return this.registrationRetryMaxAttempts;
    }

    @Override
    public String getExternalAddress() {
        return this.externalAddress;
    }

    @Override
    public String getExternalPortRange() {
        return this.externalPortRange;
    }

    @Override
    public String getBindAddress() {
        return this.bindAddress;
    }

    @Override
    public Integer getBindPort() {
        return this.bindPort;
    }

    @Override
    public MetricsCollector getUsageSupplier() {
        return this.metricsCollector;
    }

    @Override
    public URI getBlobStoreArtifactDir() {
        return this.blobStoreArtifactDir;
    }

    @Override
    public File getLocalStorageDir() {
        return this.localStorageDir;
    }

    @Override
    public Double getCpuCores() {
        return this.cpuCores;
    }

    @Override
    public Double getMemoryInMB() {
        return this.memoryInMB;
    }

    @Override
    public Double getDiskInMB() {
        return this.diskInMB;
    }

    @Override
    public double getNetworkBandwidthInMB() {
        return this.networkBandwidthInMB;
    }

    @Override
    public String taskExecutorAttributes() {
        return this.taskExecutorAttributesStr;
    }

    @Override
    public File getRegistrationStoreDir() {
        return null;
    }

    @ConstructorProperties(value={"mesosSlavePort", "zkConnectionTimeoutMs", "zkConnectionRetrySleepMs", "zkConnectionMaxRetries", "zkConnectionString", "leaderAnnouncementPath", "zkRoot", "isLocalMode", "metricsPublisherFrequencyInSeconds", "taskExecutorId", "clusterId", "metricsPort", "debugPort", "consolePort", "customPort", "sinkPort", "heartbeatInternalInMs", "tolerableConsecutiveHeartbeatFailures", "heartbeatTimeoutMs", "heartbeatRetryInitialDelayMs", "heartbeatRetryMaxDelayMs", "registrationRetryInitialDelayMillis", "registrationRetryMultiplier", "registrationRetryRandomizationFactor", "registrationRetryMaxAttempts", "externalAddress", "externalPortRange", "bindAddress", "bindPort", "blobStoreArtifactDir", "localStorageDir", "cpuCores", "memoryInMB", "diskInMB", "networkBandwidthInMB", "taskExecutorAttributesStr", "asyncHttpClientMaxConnectionsPerHost", "asyncHttpClientConnectionTimeoutMs", "asyncHttpClientRequestTimeoutMs", "asyncHttpClientReadTimeoutMs", "metricsPublisher", "metricsCollector"})
    WorkerConfigurationWritable(int mesosSlavePort, int zkConnectionTimeoutMs, int zkConnectionRetrySleepMs, int zkConnectionMaxRetries, String zkConnectionString, String leaderAnnouncementPath, String zkRoot, boolean isLocalMode, int metricsPublisherFrequencyInSeconds, String taskExecutorId, String clusterId, int metricsPort, int debugPort, int consolePort, int customPort, int sinkPort, int heartbeatInternalInMs, int tolerableConsecutiveHeartbeatFailures, int heartbeatTimeoutMs, long heartbeatRetryInitialDelayMs, long heartbeatRetryMaxDelayMs, long registrationRetryInitialDelayMillis, double registrationRetryMultiplier, double registrationRetryRandomizationFactor, int registrationRetryMaxAttempts, String externalAddress, String externalPortRange, String bindAddress, Integer bindPort, URI blobStoreArtifactDir, File localStorageDir, Double cpuCores, Double memoryInMB, Double diskInMB, double networkBandwidthInMB, String taskExecutorAttributesStr, int asyncHttpClientMaxConnectionsPerHost, int asyncHttpClientConnectionTimeoutMs, int asyncHttpClientRequestTimeoutMs, int asyncHttpClientReadTimeoutMs, MetricsPublisher metricsPublisher, MetricsCollector metricsCollector) {
        this.mesosSlavePort = mesosSlavePort;
        this.zkConnectionTimeoutMs = zkConnectionTimeoutMs;
        this.zkConnectionRetrySleepMs = zkConnectionRetrySleepMs;
        this.zkConnectionMaxRetries = zkConnectionMaxRetries;
        this.zkConnectionString = zkConnectionString;
        this.leaderAnnouncementPath = leaderAnnouncementPath;
        this.zkRoot = zkRoot;
        this.isLocalMode = isLocalMode;
        this.metricsPublisherFrequencyInSeconds = metricsPublisherFrequencyInSeconds;
        this.taskExecutorId = taskExecutorId;
        this.clusterId = clusterId;
        this.metricsPort = metricsPort;
        this.debugPort = debugPort;
        this.consolePort = consolePort;
        this.customPort = customPort;
        this.sinkPort = sinkPort;
        this.heartbeatInternalInMs = heartbeatInternalInMs;
        this.tolerableConsecutiveHeartbeatFailures = tolerableConsecutiveHeartbeatFailures;
        this.heartbeatTimeoutMs = heartbeatTimeoutMs;
        this.heartbeatRetryInitialDelayMs = heartbeatRetryInitialDelayMs;
        this.heartbeatRetryMaxDelayMs = heartbeatRetryMaxDelayMs;
        this.registrationRetryInitialDelayMillis = registrationRetryInitialDelayMillis;
        this.registrationRetryMultiplier = registrationRetryMultiplier;
        this.registrationRetryRandomizationFactor = registrationRetryRandomizationFactor;
        this.registrationRetryMaxAttempts = registrationRetryMaxAttempts;
        this.externalAddress = externalAddress;
        this.externalPortRange = externalPortRange;
        this.bindAddress = bindAddress;
        this.bindPort = bindPort;
        this.blobStoreArtifactDir = blobStoreArtifactDir;
        this.localStorageDir = localStorageDir;
        this.cpuCores = cpuCores;
        this.memoryInMB = memoryInMB;
        this.diskInMB = diskInMB;
        this.networkBandwidthInMB = networkBandwidthInMB;
        this.taskExecutorAttributesStr = taskExecutorAttributesStr;
        this.asyncHttpClientMaxConnectionsPerHost = asyncHttpClientMaxConnectionsPerHost;
        this.asyncHttpClientConnectionTimeoutMs = asyncHttpClientConnectionTimeoutMs;
        this.asyncHttpClientRequestTimeoutMs = asyncHttpClientRequestTimeoutMs;
        this.asyncHttpClientReadTimeoutMs = asyncHttpClientReadTimeoutMs;
        this.metricsPublisher = metricsPublisher;
        this.metricsCollector = metricsCollector;
    }

    public static WorkerConfigurationWritableBuilder builder() {
        return new WorkerConfigurationWritableBuilder();
    }

    public int getHeartbeatInternalInMs() {
        return this.heartbeatInternalInMs;
    }

    public int getHeartbeatTimeoutMs() {
        return this.heartbeatTimeoutMs;
    }

    public long getHeartbeatRetryInitialDelayMs() {
        return this.heartbeatRetryInitialDelayMs;
    }

    public long getHeartbeatRetryMaxDelayMs() {
        return this.heartbeatRetryMaxDelayMs;
    }

    public long getRegistrationRetryInitialDelayMillis() {
        return this.registrationRetryInitialDelayMillis;
    }

    public double getRegistrationRetryMultiplier() {
        return this.registrationRetryMultiplier;
    }

    public double getRegistrationRetryRandomizationFactor() {
        return this.registrationRetryRandomizationFactor;
    }

    public int getRegistrationRetryMaxAttempts() {
        return this.registrationRetryMaxAttempts;
    }

    public String getTaskExecutorAttributesStr() {
        return this.taskExecutorAttributesStr;
    }

    public int getAsyncHttpClientMaxConnectionsPerHost() {
        return this.asyncHttpClientMaxConnectionsPerHost;
    }

    public int getAsyncHttpClientConnectionTimeoutMs() {
        return this.asyncHttpClientConnectionTimeoutMs;
    }

    public int getAsyncHttpClientRequestTimeoutMs() {
        return this.asyncHttpClientRequestTimeoutMs;
    }

    public int getAsyncHttpClientReadTimeoutMs() {
        return this.asyncHttpClientReadTimeoutMs;
    }

    public MetricsCollector getMetricsCollector() {
        return this.metricsCollector;
    }

    public void setMesosSlavePort(int mesosSlavePort) {
        this.mesosSlavePort = mesosSlavePort;
    }

    public void setZkConnectionTimeoutMs(int zkConnectionTimeoutMs) {
        this.zkConnectionTimeoutMs = zkConnectionTimeoutMs;
    }

    public void setZkConnectionRetrySleepMs(int zkConnectionRetrySleepMs) {
        this.zkConnectionRetrySleepMs = zkConnectionRetrySleepMs;
    }

    public void setZkConnectionMaxRetries(int zkConnectionMaxRetries) {
        this.zkConnectionMaxRetries = zkConnectionMaxRetries;
    }

    public void setZkConnectionString(String zkConnectionString) {
        this.zkConnectionString = zkConnectionString;
    }

    public void setLeaderAnnouncementPath(String leaderAnnouncementPath) {
        this.leaderAnnouncementPath = leaderAnnouncementPath;
    }

    public void setZkRoot(String zkRoot) {
        this.zkRoot = zkRoot;
    }

    public void setLocalMode(boolean isLocalMode) {
        this.isLocalMode = isLocalMode;
    }

    public void setMetricsPublisherFrequencyInSeconds(int metricsPublisherFrequencyInSeconds) {
        this.metricsPublisherFrequencyInSeconds = metricsPublisherFrequencyInSeconds;
    }

    public void setTaskExecutorId(String taskExecutorId) {
        this.taskExecutorId = taskExecutorId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public void setMetricsPort(int metricsPort) {
        this.metricsPort = metricsPort;
    }

    public void setDebugPort(int debugPort) {
        this.debugPort = debugPort;
    }

    public void setConsolePort(int consolePort) {
        this.consolePort = consolePort;
    }

    public void setCustomPort(int customPort) {
        this.customPort = customPort;
    }

    public void setSinkPort(int sinkPort) {
        this.sinkPort = sinkPort;
    }

    public void setHeartbeatInternalInMs(int heartbeatInternalInMs) {
        this.heartbeatInternalInMs = heartbeatInternalInMs;
    }

    public void setTolerableConsecutiveHeartbeatFailures(int tolerableConsecutiveHeartbeatFailures) {
        this.tolerableConsecutiveHeartbeatFailures = tolerableConsecutiveHeartbeatFailures;
    }

    public void setHeartbeatTimeoutMs(int heartbeatTimeoutMs) {
        this.heartbeatTimeoutMs = heartbeatTimeoutMs;
    }

    public void setHeartbeatRetryInitialDelayMs(long heartbeatRetryInitialDelayMs) {
        this.heartbeatRetryInitialDelayMs = heartbeatRetryInitialDelayMs;
    }

    public void setHeartbeatRetryMaxDelayMs(long heartbeatRetryMaxDelayMs) {
        this.heartbeatRetryMaxDelayMs = heartbeatRetryMaxDelayMs;
    }

    public void setRegistrationRetryInitialDelayMillis(long registrationRetryInitialDelayMillis) {
        this.registrationRetryInitialDelayMillis = registrationRetryInitialDelayMillis;
    }

    public void setRegistrationRetryMultiplier(double registrationRetryMultiplier) {
        this.registrationRetryMultiplier = registrationRetryMultiplier;
    }

    public void setRegistrationRetryRandomizationFactor(double registrationRetryRandomizationFactor) {
        this.registrationRetryRandomizationFactor = registrationRetryRandomizationFactor;
    }

    public void setRegistrationRetryMaxAttempts(int registrationRetryMaxAttempts) {
        this.registrationRetryMaxAttempts = registrationRetryMaxAttempts;
    }

    public void setExternalAddress(String externalAddress) {
        this.externalAddress = externalAddress;
    }

    public void setExternalPortRange(String externalPortRange) {
        this.externalPortRange = externalPortRange;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public void setBindPort(Integer bindPort) {
        this.bindPort = bindPort;
    }

    public void setBlobStoreArtifactDir(URI blobStoreArtifactDir) {
        this.blobStoreArtifactDir = blobStoreArtifactDir;
    }

    public void setLocalStorageDir(File localStorageDir) {
        this.localStorageDir = localStorageDir;
    }

    public void setCpuCores(Double cpuCores) {
        this.cpuCores = cpuCores;
    }

    public void setMemoryInMB(Double memoryInMB) {
        this.memoryInMB = memoryInMB;
    }

    public void setDiskInMB(Double diskInMB) {
        this.diskInMB = diskInMB;
    }

    public void setNetworkBandwidthInMB(double networkBandwidthInMB) {
        this.networkBandwidthInMB = networkBandwidthInMB;
    }

    public void setTaskExecutorAttributesStr(String taskExecutorAttributesStr) {
        this.taskExecutorAttributesStr = taskExecutorAttributesStr;
    }

    public void setAsyncHttpClientMaxConnectionsPerHost(int asyncHttpClientMaxConnectionsPerHost) {
        this.asyncHttpClientMaxConnectionsPerHost = asyncHttpClientMaxConnectionsPerHost;
    }

    public void setAsyncHttpClientConnectionTimeoutMs(int asyncHttpClientConnectionTimeoutMs) {
        this.asyncHttpClientConnectionTimeoutMs = asyncHttpClientConnectionTimeoutMs;
    }

    public void setAsyncHttpClientRequestTimeoutMs(int asyncHttpClientRequestTimeoutMs) {
        this.asyncHttpClientRequestTimeoutMs = asyncHttpClientRequestTimeoutMs;
    }

    public void setAsyncHttpClientReadTimeoutMs(int asyncHttpClientReadTimeoutMs) {
        this.asyncHttpClientReadTimeoutMs = asyncHttpClientReadTimeoutMs;
    }

    public void setMetricsPublisher(MetricsPublisher metricsPublisher) {
        this.metricsPublisher = metricsPublisher;
    }

    public void setMetricsCollector(MetricsCollector metricsCollector) {
        this.metricsCollector = metricsCollector;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkerConfigurationWritable)) {
            return false;
        }
        WorkerConfigurationWritable other = (WorkerConfigurationWritable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMesosSlavePort() != other.getMesosSlavePort()) {
            return false;
        }
        if (this.getZkConnectionTimeoutMs() != other.getZkConnectionTimeoutMs()) {
            return false;
        }
        if (this.getZkConnectionRetrySleepMs() != other.getZkConnectionRetrySleepMs()) {
            return false;
        }
        if (this.getZkConnectionMaxRetries() != other.getZkConnectionMaxRetries()) {
            return false;
        }
        if (this.isLocalMode() != other.isLocalMode()) {
            return false;
        }
        if (this.getMetricsPublisherFrequencyInSeconds() != other.getMetricsPublisherFrequencyInSeconds()) {
            return false;
        }
        if (this.getMetricsPort() != other.getMetricsPort()) {
            return false;
        }
        if (this.getDebugPort() != other.getDebugPort()) {
            return false;
        }
        if (this.getConsolePort() != other.getConsolePort()) {
            return false;
        }
        if (this.getCustomPort() != other.getCustomPort()) {
            return false;
        }
        if (this.getSinkPort() != other.getSinkPort()) {
            return false;
        }
        if (this.getHeartbeatInternalInMs() != other.getHeartbeatInternalInMs()) {
            return false;
        }
        if (this.getTolerableConsecutiveHeartbeatFailures() != other.getTolerableConsecutiveHeartbeatFailures()) {
            return false;
        }
        if (this.getHeartbeatTimeoutMs() != other.getHeartbeatTimeoutMs()) {
            return false;
        }
        if (this.getHeartbeatRetryInitialDelayMs() != other.getHeartbeatRetryInitialDelayMs()) {
            return false;
        }
        if (this.getHeartbeatRetryMaxDelayMs() != other.getHeartbeatRetryMaxDelayMs()) {
            return false;
        }
        if (this.getRegistrationRetryInitialDelayMillis() != other.getRegistrationRetryInitialDelayMillis()) {
            return false;
        }
        if (Double.compare(this.getRegistrationRetryMultiplier(), other.getRegistrationRetryMultiplier()) != 0) {
            return false;
        }
        if (Double.compare(this.getRegistrationRetryRandomizationFactor(), other.getRegistrationRetryRandomizationFactor()) != 0) {
            return false;
        }
        if (this.getRegistrationRetryMaxAttempts() != other.getRegistrationRetryMaxAttempts()) {
            return false;
        }
        if (Double.compare(this.getNetworkBandwidthInMB(), other.getNetworkBandwidthInMB()) != 0) {
            return false;
        }
        if (this.getAsyncHttpClientMaxConnectionsPerHost() != other.getAsyncHttpClientMaxConnectionsPerHost()) {
            return false;
        }
        if (this.getAsyncHttpClientConnectionTimeoutMs() != other.getAsyncHttpClientConnectionTimeoutMs()) {
            return false;
        }
        if (this.getAsyncHttpClientRequestTimeoutMs() != other.getAsyncHttpClientRequestTimeoutMs()) {
            return false;
        }
        if (this.getAsyncHttpClientReadTimeoutMs() != other.getAsyncHttpClientReadTimeoutMs()) {
            return false;
        }
        Integer this$bindPort = this.getBindPort();
        Integer other$bindPort = other.getBindPort();
        if (this$bindPort == null ? other$bindPort != null : !((Object)this$bindPort).equals(other$bindPort)) {
            return false;
        }
        Double this$cpuCores = this.getCpuCores();
        Double other$cpuCores = other.getCpuCores();
        if (this$cpuCores == null ? other$cpuCores != null : !((Object)this$cpuCores).equals(other$cpuCores)) {
            return false;
        }
        Double this$memoryInMB = this.getMemoryInMB();
        Double other$memoryInMB = other.getMemoryInMB();
        if (this$memoryInMB == null ? other$memoryInMB != null : !((Object)this$memoryInMB).equals(other$memoryInMB)) {
            return false;
        }
        Double this$diskInMB = this.getDiskInMB();
        Double other$diskInMB = other.getDiskInMB();
        if (this$diskInMB == null ? other$diskInMB != null : !((Object)this$diskInMB).equals(other$diskInMB)) {
            return false;
        }
        String this$zkConnectionString = this.getZkConnectionString();
        String other$zkConnectionString = other.getZkConnectionString();
        if (this$zkConnectionString == null ? other$zkConnectionString != null : !this$zkConnectionString.equals(other$zkConnectionString)) {
            return false;
        }
        String this$leaderAnnouncementPath = this.getLeaderAnnouncementPath();
        String other$leaderAnnouncementPath = other.getLeaderAnnouncementPath();
        if (this$leaderAnnouncementPath == null ? other$leaderAnnouncementPath != null : !this$leaderAnnouncementPath.equals(other$leaderAnnouncementPath)) {
            return false;
        }
        String this$zkRoot = this.getZkRoot();
        String other$zkRoot = other.getZkRoot();
        if (this$zkRoot == null ? other$zkRoot != null : !this$zkRoot.equals(other$zkRoot)) {
            return false;
        }
        String this$taskExecutorId = this.getTaskExecutorId();
        String other$taskExecutorId = other.getTaskExecutorId();
        if (this$taskExecutorId == null ? other$taskExecutorId != null : !this$taskExecutorId.equals(other$taskExecutorId)) {
            return false;
        }
        String this$clusterId = this.getClusterId();
        String other$clusterId = other.getClusterId();
        if (this$clusterId == null ? other$clusterId != null : !this$clusterId.equals(other$clusterId)) {
            return false;
        }
        String this$externalAddress = this.getExternalAddress();
        String other$externalAddress = other.getExternalAddress();
        if (this$externalAddress == null ? other$externalAddress != null : !this$externalAddress.equals(other$externalAddress)) {
            return false;
        }
        String this$externalPortRange = this.getExternalPortRange();
        String other$externalPortRange = other.getExternalPortRange();
        if (this$externalPortRange == null ? other$externalPortRange != null : !this$externalPortRange.equals(other$externalPortRange)) {
            return false;
        }
        String this$bindAddress = this.getBindAddress();
        String other$bindAddress = other.getBindAddress();
        if (this$bindAddress == null ? other$bindAddress != null : !this$bindAddress.equals(other$bindAddress)) {
            return false;
        }
        URI this$blobStoreArtifactDir = this.getBlobStoreArtifactDir();
        URI other$blobStoreArtifactDir = other.getBlobStoreArtifactDir();
        if (this$blobStoreArtifactDir == null ? other$blobStoreArtifactDir != null : !((Object)this$blobStoreArtifactDir).equals(other$blobStoreArtifactDir)) {
            return false;
        }
        File this$localStorageDir = this.getLocalStorageDir();
        File other$localStorageDir = other.getLocalStorageDir();
        if (this$localStorageDir == null ? other$localStorageDir != null : !((Object)this$localStorageDir).equals(other$localStorageDir)) {
            return false;
        }
        String this$taskExecutorAttributesStr = this.getTaskExecutorAttributesStr();
        String other$taskExecutorAttributesStr = other.getTaskExecutorAttributesStr();
        if (this$taskExecutorAttributesStr == null ? other$taskExecutorAttributesStr != null : !this$taskExecutorAttributesStr.equals(other$taskExecutorAttributesStr)) {
            return false;
        }
        MetricsPublisher this$metricsPublisher = this.getMetricsPublisher();
        MetricsPublisher other$metricsPublisher = other.getMetricsPublisher();
        if (this$metricsPublisher == null ? other$metricsPublisher != null : !this$metricsPublisher.equals(other$metricsPublisher)) {
            return false;
        }
        MetricsCollector this$metricsCollector = this.getMetricsCollector();
        MetricsCollector other$metricsCollector = other.getMetricsCollector();
        return !(this$metricsCollector == null ? other$metricsCollector != null : !this$metricsCollector.equals(other$metricsCollector));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkerConfigurationWritable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMesosSlavePort();
        result = result * 59 + this.getZkConnectionTimeoutMs();
        result = result * 59 + this.getZkConnectionRetrySleepMs();
        result = result * 59 + this.getZkConnectionMaxRetries();
        result = result * 59 + (this.isLocalMode() ? 79 : 97);
        result = result * 59 + this.getMetricsPublisherFrequencyInSeconds();
        result = result * 59 + this.getMetricsPort();
        result = result * 59 + this.getDebugPort();
        result = result * 59 + this.getConsolePort();
        result = result * 59 + this.getCustomPort();
        result = result * 59 + this.getSinkPort();
        result = result * 59 + this.getHeartbeatInternalInMs();
        result = result * 59 + this.getTolerableConsecutiveHeartbeatFailures();
        result = result * 59 + this.getHeartbeatTimeoutMs();
        long $heartbeatRetryInitialDelayMs = this.getHeartbeatRetryInitialDelayMs();
        result = result * 59 + (int)($heartbeatRetryInitialDelayMs >>> 32 ^ $heartbeatRetryInitialDelayMs);
        long $heartbeatRetryMaxDelayMs = this.getHeartbeatRetryMaxDelayMs();
        result = result * 59 + (int)($heartbeatRetryMaxDelayMs >>> 32 ^ $heartbeatRetryMaxDelayMs);
        long $registrationRetryInitialDelayMillis = this.getRegistrationRetryInitialDelayMillis();
        result = result * 59 + (int)($registrationRetryInitialDelayMillis >>> 32 ^ $registrationRetryInitialDelayMillis);
        long $registrationRetryMultiplier = Double.doubleToLongBits(this.getRegistrationRetryMultiplier());
        result = result * 59 + (int)($registrationRetryMultiplier >>> 32 ^ $registrationRetryMultiplier);
        long $registrationRetryRandomizationFactor = Double.doubleToLongBits(this.getRegistrationRetryRandomizationFactor());
        result = result * 59 + (int)($registrationRetryRandomizationFactor >>> 32 ^ $registrationRetryRandomizationFactor);
        result = result * 59 + this.getRegistrationRetryMaxAttempts();
        long $networkBandwidthInMB = Double.doubleToLongBits(this.getNetworkBandwidthInMB());
        result = result * 59 + (int)($networkBandwidthInMB >>> 32 ^ $networkBandwidthInMB);
        result = result * 59 + this.getAsyncHttpClientMaxConnectionsPerHost();
        result = result * 59 + this.getAsyncHttpClientConnectionTimeoutMs();
        result = result * 59 + this.getAsyncHttpClientRequestTimeoutMs();
        result = result * 59 + this.getAsyncHttpClientReadTimeoutMs();
        Integer $bindPort = this.getBindPort();
        result = result * 59 + ($bindPort == null ? 43 : ((Object)$bindPort).hashCode());
        Double $cpuCores = this.getCpuCores();
        result = result * 59 + ($cpuCores == null ? 43 : ((Object)$cpuCores).hashCode());
        Double $memoryInMB = this.getMemoryInMB();
        result = result * 59 + ($memoryInMB == null ? 43 : ((Object)$memoryInMB).hashCode());
        Double $diskInMB = this.getDiskInMB();
        result = result * 59 + ($diskInMB == null ? 43 : ((Object)$diskInMB).hashCode());
        String $zkConnectionString = this.getZkConnectionString();
        result = result * 59 + ($zkConnectionString == null ? 43 : $zkConnectionString.hashCode());
        String $leaderAnnouncementPath = this.getLeaderAnnouncementPath();
        result = result * 59 + ($leaderAnnouncementPath == null ? 43 : $leaderAnnouncementPath.hashCode());
        String $zkRoot = this.getZkRoot();
        result = result * 59 + ($zkRoot == null ? 43 : $zkRoot.hashCode());
        String $taskExecutorId = this.getTaskExecutorId();
        result = result * 59 + ($taskExecutorId == null ? 43 : $taskExecutorId.hashCode());
        String $clusterId = this.getClusterId();
        result = result * 59 + ($clusterId == null ? 43 : $clusterId.hashCode());
        String $externalAddress = this.getExternalAddress();
        result = result * 59 + ($externalAddress == null ? 43 : $externalAddress.hashCode());
        String $externalPortRange = this.getExternalPortRange();
        result = result * 59 + ($externalPortRange == null ? 43 : $externalPortRange.hashCode());
        String $bindAddress = this.getBindAddress();
        result = result * 59 + ($bindAddress == null ? 43 : $bindAddress.hashCode());
        URI $blobStoreArtifactDir = this.getBlobStoreArtifactDir();
        result = result * 59 + ($blobStoreArtifactDir == null ? 43 : ((Object)$blobStoreArtifactDir).hashCode());
        File $localStorageDir = this.getLocalStorageDir();
        result = result * 59 + ($localStorageDir == null ? 43 : ((Object)$localStorageDir).hashCode());
        String $taskExecutorAttributesStr = this.getTaskExecutorAttributesStr();
        result = result * 59 + ($taskExecutorAttributesStr == null ? 43 : $taskExecutorAttributesStr.hashCode());
        MetricsPublisher $metricsPublisher = this.getMetricsPublisher();
        result = result * 59 + ($metricsPublisher == null ? 43 : $metricsPublisher.hashCode());
        MetricsCollector $metricsCollector = this.getMetricsCollector();
        result = result * 59 + ($metricsCollector == null ? 43 : $metricsCollector.hashCode());
        return result;
    }

    public String toString() {
        return "WorkerConfigurationWritable(mesosSlavePort=" + this.getMesosSlavePort() + ", zkConnectionTimeoutMs=" + this.getZkConnectionTimeoutMs() + ", zkConnectionRetrySleepMs=" + this.getZkConnectionRetrySleepMs() + ", zkConnectionMaxRetries=" + this.getZkConnectionMaxRetries() + ", zkConnectionString=" + this.getZkConnectionString() + ", leaderAnnouncementPath=" + this.getLeaderAnnouncementPath() + ", zkRoot=" + this.getZkRoot() + ", isLocalMode=" + this.isLocalMode() + ", metricsPublisherFrequencyInSeconds=" + this.getMetricsPublisherFrequencyInSeconds() + ", taskExecutorId=" + this.getTaskExecutorId() + ", clusterId=" + this.getClusterId() + ", metricsPort=" + this.getMetricsPort() + ", debugPort=" + this.getDebugPort() + ", consolePort=" + this.getConsolePort() + ", customPort=" + this.getCustomPort() + ", sinkPort=" + this.getSinkPort() + ", heartbeatInternalInMs=" + this.getHeartbeatInternalInMs() + ", tolerableConsecutiveHeartbeatFailures=" + this.getTolerableConsecutiveHeartbeatFailures() + ", heartbeatTimeoutMs=" + this.getHeartbeatTimeoutMs() + ", heartbeatRetryInitialDelayMs=" + this.getHeartbeatRetryInitialDelayMs() + ", heartbeatRetryMaxDelayMs=" + this.getHeartbeatRetryMaxDelayMs() + ", registrationRetryInitialDelayMillis=" + this.getRegistrationRetryInitialDelayMillis() + ", registrationRetryMultiplier=" + this.getRegistrationRetryMultiplier() + ", registrationRetryRandomizationFactor=" + this.getRegistrationRetryRandomizationFactor() + ", registrationRetryMaxAttempts=" + this.getRegistrationRetryMaxAttempts() + ", externalAddress=" + this.getExternalAddress() + ", externalPortRange=" + this.getExternalPortRange() + ", bindAddress=" + this.getBindAddress() + ", bindPort=" + this.getBindPort() + ", blobStoreArtifactDir=" + this.getBlobStoreArtifactDir() + ", localStorageDir=" + this.getLocalStorageDir() + ", cpuCores=" + this.getCpuCores() + ", memoryInMB=" + this.getMemoryInMB() + ", diskInMB=" + this.getDiskInMB() + ", networkBandwidthInMB=" + this.getNetworkBandwidthInMB() + ", taskExecutorAttributesStr=" + this.getTaskExecutorAttributesStr() + ", asyncHttpClientMaxConnectionsPerHost=" + this.getAsyncHttpClientMaxConnectionsPerHost() + ", asyncHttpClientConnectionTimeoutMs=" + this.getAsyncHttpClientConnectionTimeoutMs() + ", asyncHttpClientRequestTimeoutMs=" + this.getAsyncHttpClientRequestTimeoutMs() + ", asyncHttpClientReadTimeoutMs=" + this.getAsyncHttpClientReadTimeoutMs() + ", metricsPublisher=" + this.getMetricsPublisher() + ", metricsCollector=" + this.getMetricsCollector() + ")";
    }

    public static class WorkerConfigurationWritableBuilder {
        private int mesosSlavePort;
        private int zkConnectionTimeoutMs;
        private int zkConnectionRetrySleepMs;
        private int zkConnectionMaxRetries;
        private String zkConnectionString;
        private String leaderAnnouncementPath;
        private String zkRoot;
        private boolean isLocalMode;
        private int metricsPublisherFrequencyInSeconds;
        private String taskExecutorId;
        private String clusterId;
        private int metricsPort;
        private int debugPort;
        private int consolePort;
        private int customPort;
        private int sinkPort;
        private int heartbeatInternalInMs;
        private int tolerableConsecutiveHeartbeatFailures;
        private int heartbeatTimeoutMs;
        private long heartbeatRetryInitialDelayMs;
        private long heartbeatRetryMaxDelayMs;
        private long registrationRetryInitialDelayMillis;
        private double registrationRetryMultiplier;
        private double registrationRetryRandomizationFactor;
        private int registrationRetryMaxAttempts;
        private String externalAddress;
        private String externalPortRange;
        private String bindAddress;
        private Integer bindPort;
        private URI blobStoreArtifactDir;
        private File localStorageDir;
        private Double cpuCores;
        private Double memoryInMB;
        private Double diskInMB;
        private double networkBandwidthInMB;
        private String taskExecutorAttributesStr;
        private int asyncHttpClientMaxConnectionsPerHost;
        private int asyncHttpClientConnectionTimeoutMs;
        private int asyncHttpClientRequestTimeoutMs;
        private int asyncHttpClientReadTimeoutMs;
        private MetricsPublisher metricsPublisher;
        private MetricsCollector metricsCollector;

        WorkerConfigurationWritableBuilder() {
        }

        public WorkerConfigurationWritableBuilder mesosSlavePort(int mesosSlavePort) {
            this.mesosSlavePort = mesosSlavePort;
            return this;
        }

        public WorkerConfigurationWritableBuilder zkConnectionTimeoutMs(int zkConnectionTimeoutMs) {
            this.zkConnectionTimeoutMs = zkConnectionTimeoutMs;
            return this;
        }

        public WorkerConfigurationWritableBuilder zkConnectionRetrySleepMs(int zkConnectionRetrySleepMs) {
            this.zkConnectionRetrySleepMs = zkConnectionRetrySleepMs;
            return this;
        }

        public WorkerConfigurationWritableBuilder zkConnectionMaxRetries(int zkConnectionMaxRetries) {
            this.zkConnectionMaxRetries = zkConnectionMaxRetries;
            return this;
        }

        public WorkerConfigurationWritableBuilder zkConnectionString(String zkConnectionString) {
            this.zkConnectionString = zkConnectionString;
            return this;
        }

        public WorkerConfigurationWritableBuilder leaderAnnouncementPath(String leaderAnnouncementPath) {
            this.leaderAnnouncementPath = leaderAnnouncementPath;
            return this;
        }

        public WorkerConfigurationWritableBuilder zkRoot(String zkRoot) {
            this.zkRoot = zkRoot;
            return this;
        }

        public WorkerConfigurationWritableBuilder isLocalMode(boolean isLocalMode) {
            this.isLocalMode = isLocalMode;
            return this;
        }

        public WorkerConfigurationWritableBuilder metricsPublisherFrequencyInSeconds(int metricsPublisherFrequencyInSeconds) {
            this.metricsPublisherFrequencyInSeconds = metricsPublisherFrequencyInSeconds;
            return this;
        }

        public WorkerConfigurationWritableBuilder taskExecutorId(String taskExecutorId) {
            this.taskExecutorId = taskExecutorId;
            return this;
        }

        public WorkerConfigurationWritableBuilder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public WorkerConfigurationWritableBuilder metricsPort(int metricsPort) {
            this.metricsPort = metricsPort;
            return this;
        }

        public WorkerConfigurationWritableBuilder debugPort(int debugPort) {
            this.debugPort = debugPort;
            return this;
        }

        public WorkerConfigurationWritableBuilder consolePort(int consolePort) {
            this.consolePort = consolePort;
            return this;
        }

        public WorkerConfigurationWritableBuilder customPort(int customPort) {
            this.customPort = customPort;
            return this;
        }

        public WorkerConfigurationWritableBuilder sinkPort(int sinkPort) {
            this.sinkPort = sinkPort;
            return this;
        }

        public WorkerConfigurationWritableBuilder heartbeatInternalInMs(int heartbeatInternalInMs) {
            this.heartbeatInternalInMs = heartbeatInternalInMs;
            return this;
        }

        public WorkerConfigurationWritableBuilder tolerableConsecutiveHeartbeatFailures(int tolerableConsecutiveHeartbeatFailures) {
            this.tolerableConsecutiveHeartbeatFailures = tolerableConsecutiveHeartbeatFailures;
            return this;
        }

        public WorkerConfigurationWritableBuilder heartbeatTimeoutMs(int heartbeatTimeoutMs) {
            this.heartbeatTimeoutMs = heartbeatTimeoutMs;
            return this;
        }

        public WorkerConfigurationWritableBuilder heartbeatRetryInitialDelayMs(long heartbeatRetryInitialDelayMs) {
            this.heartbeatRetryInitialDelayMs = heartbeatRetryInitialDelayMs;
            return this;
        }

        public WorkerConfigurationWritableBuilder heartbeatRetryMaxDelayMs(long heartbeatRetryMaxDelayMs) {
            this.heartbeatRetryMaxDelayMs = heartbeatRetryMaxDelayMs;
            return this;
        }

        public WorkerConfigurationWritableBuilder registrationRetryInitialDelayMillis(long registrationRetryInitialDelayMillis) {
            this.registrationRetryInitialDelayMillis = registrationRetryInitialDelayMillis;
            return this;
        }

        public WorkerConfigurationWritableBuilder registrationRetryMultiplier(double registrationRetryMultiplier) {
            this.registrationRetryMultiplier = registrationRetryMultiplier;
            return this;
        }

        public WorkerConfigurationWritableBuilder registrationRetryRandomizationFactor(double registrationRetryRandomizationFactor) {
            this.registrationRetryRandomizationFactor = registrationRetryRandomizationFactor;
            return this;
        }

        public WorkerConfigurationWritableBuilder registrationRetryMaxAttempts(int registrationRetryMaxAttempts) {
            this.registrationRetryMaxAttempts = registrationRetryMaxAttempts;
            return this;
        }

        public WorkerConfigurationWritableBuilder externalAddress(String externalAddress) {
            this.externalAddress = externalAddress;
            return this;
        }

        public WorkerConfigurationWritableBuilder externalPortRange(String externalPortRange) {
            this.externalPortRange = externalPortRange;
            return this;
        }

        public WorkerConfigurationWritableBuilder bindAddress(String bindAddress) {
            this.bindAddress = bindAddress;
            return this;
        }

        public WorkerConfigurationWritableBuilder bindPort(Integer bindPort) {
            this.bindPort = bindPort;
            return this;
        }

        public WorkerConfigurationWritableBuilder blobStoreArtifactDir(URI blobStoreArtifactDir) {
            this.blobStoreArtifactDir = blobStoreArtifactDir;
            return this;
        }

        public WorkerConfigurationWritableBuilder localStorageDir(File localStorageDir) {
            this.localStorageDir = localStorageDir;
            return this;
        }

        public WorkerConfigurationWritableBuilder cpuCores(Double cpuCores) {
            this.cpuCores = cpuCores;
            return this;
        }

        public WorkerConfigurationWritableBuilder memoryInMB(Double memoryInMB) {
            this.memoryInMB = memoryInMB;
            return this;
        }

        public WorkerConfigurationWritableBuilder diskInMB(Double diskInMB) {
            this.diskInMB = diskInMB;
            return this;
        }

        public WorkerConfigurationWritableBuilder networkBandwidthInMB(double networkBandwidthInMB) {
            this.networkBandwidthInMB = networkBandwidthInMB;
            return this;
        }

        public WorkerConfigurationWritableBuilder taskExecutorAttributesStr(String taskExecutorAttributesStr) {
            this.taskExecutorAttributesStr = taskExecutorAttributesStr;
            return this;
        }

        public WorkerConfigurationWritableBuilder asyncHttpClientMaxConnectionsPerHost(int asyncHttpClientMaxConnectionsPerHost) {
            this.asyncHttpClientMaxConnectionsPerHost = asyncHttpClientMaxConnectionsPerHost;
            return this;
        }

        public WorkerConfigurationWritableBuilder asyncHttpClientConnectionTimeoutMs(int asyncHttpClientConnectionTimeoutMs) {
            this.asyncHttpClientConnectionTimeoutMs = asyncHttpClientConnectionTimeoutMs;
            return this;
        }

        public WorkerConfigurationWritableBuilder asyncHttpClientRequestTimeoutMs(int asyncHttpClientRequestTimeoutMs) {
            this.asyncHttpClientRequestTimeoutMs = asyncHttpClientRequestTimeoutMs;
            return this;
        }

        public WorkerConfigurationWritableBuilder asyncHttpClientReadTimeoutMs(int asyncHttpClientReadTimeoutMs) {
            this.asyncHttpClientReadTimeoutMs = asyncHttpClientReadTimeoutMs;
            return this;
        }

        public WorkerConfigurationWritableBuilder metricsPublisher(MetricsPublisher metricsPublisher) {
            this.metricsPublisher = metricsPublisher;
            return this;
        }

        public WorkerConfigurationWritableBuilder metricsCollector(MetricsCollector metricsCollector) {
            this.metricsCollector = metricsCollector;
            return this;
        }

        public WorkerConfigurationWritable build() {
            return new WorkerConfigurationWritable(this.mesosSlavePort, this.zkConnectionTimeoutMs, this.zkConnectionRetrySleepMs, this.zkConnectionMaxRetries, this.zkConnectionString, this.leaderAnnouncementPath, this.zkRoot, this.isLocalMode, this.metricsPublisherFrequencyInSeconds, this.taskExecutorId, this.clusterId, this.metricsPort, this.debugPort, this.consolePort, this.customPort, this.sinkPort, this.heartbeatInternalInMs, this.tolerableConsecutiveHeartbeatFailures, this.heartbeatTimeoutMs, this.heartbeatRetryInitialDelayMs, this.heartbeatRetryMaxDelayMs, this.registrationRetryInitialDelayMillis, this.registrationRetryMultiplier, this.registrationRetryRandomizationFactor, this.registrationRetryMaxAttempts, this.externalAddress, this.externalPortRange, this.bindAddress, this.bindPort, this.blobStoreArtifactDir, this.localStorageDir, this.cpuCores, this.memoryInMB, this.diskInMB, this.networkBandwidthInMB, this.taskExecutorAttributesStr, this.asyncHttpClientMaxConnectionsPerHost, this.asyncHttpClientConnectionTimeoutMs, this.asyncHttpClientRequestTimeoutMs, this.asyncHttpClientReadTimeoutMs, this.metricsPublisher, this.metricsCollector);
        }

        public String toString() {
            return "WorkerConfigurationWritable.WorkerConfigurationWritableBuilder(mesosSlavePort=" + this.mesosSlavePort + ", zkConnectionTimeoutMs=" + this.zkConnectionTimeoutMs + ", zkConnectionRetrySleepMs=" + this.zkConnectionRetrySleepMs + ", zkConnectionMaxRetries=" + this.zkConnectionMaxRetries + ", zkConnectionString=" + this.zkConnectionString + ", leaderAnnouncementPath=" + this.leaderAnnouncementPath + ", zkRoot=" + this.zkRoot + ", isLocalMode=" + this.isLocalMode + ", metricsPublisherFrequencyInSeconds=" + this.metricsPublisherFrequencyInSeconds + ", taskExecutorId=" + this.taskExecutorId + ", clusterId=" + this.clusterId + ", metricsPort=" + this.metricsPort + ", debugPort=" + this.debugPort + ", consolePort=" + this.consolePort + ", customPort=" + this.customPort + ", sinkPort=" + this.sinkPort + ", heartbeatInternalInMs=" + this.heartbeatInternalInMs + ", tolerableConsecutiveHeartbeatFailures=" + this.tolerableConsecutiveHeartbeatFailures + ", heartbeatTimeoutMs=" + this.heartbeatTimeoutMs + ", heartbeatRetryInitialDelayMs=" + this.heartbeatRetryInitialDelayMs + ", heartbeatRetryMaxDelayMs=" + this.heartbeatRetryMaxDelayMs + ", registrationRetryInitialDelayMillis=" + this.registrationRetryInitialDelayMillis + ", registrationRetryMultiplier=" + this.registrationRetryMultiplier + ", registrationRetryRandomizationFactor=" + this.registrationRetryRandomizationFactor + ", registrationRetryMaxAttempts=" + this.registrationRetryMaxAttempts + ", externalAddress=" + this.externalAddress + ", externalPortRange=" + this.externalPortRange + ", bindAddress=" + this.bindAddress + ", bindPort=" + this.bindPort + ", blobStoreArtifactDir=" + this.blobStoreArtifactDir + ", localStorageDir=" + this.localStorageDir + ", cpuCores=" + this.cpuCores + ", memoryInMB=" + this.memoryInMB + ", diskInMB=" + this.diskInMB + ", networkBandwidthInMB=" + this.networkBandwidthInMB + ", taskExecutorAttributesStr=" + this.taskExecutorAttributesStr + ", asyncHttpClientMaxConnectionsPerHost=" + this.asyncHttpClientMaxConnectionsPerHost + ", asyncHttpClientConnectionTimeoutMs=" + this.asyncHttpClientConnectionTimeoutMs + ", asyncHttpClientRequestTimeoutMs=" + this.asyncHttpClientRequestTimeoutMs + ", asyncHttpClientReadTimeoutMs=" + this.asyncHttpClientReadTimeoutMs + ", metricsPublisher=" + this.metricsPublisher + ", metricsCollector=" + this.metricsCollector + ")";
        }
    }
}

