/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.loader.cgroups;

import io.mantisrx.runtime.loader.cgroups.ProcFileReader;
import io.mantisrx.runtime.loader.cgroups.SubsystemProcess;
import io.mantisrx.runtime.loader.config.Usage;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

class NetworkSubsystemProcess
implements SubsystemProcess {
    private final String fileName;
    private final String device;

    private Map<String, NetworkStats> getDeviceLevelStats() throws IOException {
        HashMap<String, NetworkStats> result = new HashMap<String, NetworkStats>();
        try (ProcFileReader reader = new ProcFileReader(Files.newInputStream(Paths.get(this.fileName, new String[0]), new OpenOption[0]));){
            reader.finishLine();
            reader.finishLine();
            while (reader.hasMoreData()) {
                String iface = reader.nextString();
                if (iface.isEmpty()) {
                    break;
                }
                long rxBytes = reader.nextLong();
                long rxPackets = reader.nextLong();
                reader.nextLong();
                reader.nextLong();
                reader.nextLong();
                reader.nextLong();
                reader.nextLong();
                reader.nextLong();
                long txBytes = reader.nextLong();
                long txPackets = reader.nextLong();
                result.put(iface, new NetworkStats(rxBytes, rxPackets, txBytes, txPackets));
                reader.finishLine();
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (NullPointerException | NumberFormatException e) {
            throw new IllegalStateException("problem parsing stats: " + e);
        }
        return result;
    }

    @Override
    public void getUsage(Usage.UsageBuilder usageBuilder) throws IOException {
        Map<String, NetworkStats> result = this.getDeviceLevelStats();
        NetworkStats stats = result.get(this.device);
        usageBuilder.networkReadBytes(stats.getRxBytes());
        usageBuilder.networkWriteBytes(stats.getTxBytes());
    }

    @ConstructorProperties(value={"fileName", "device"})
    public NetworkSubsystemProcess(String fileName, String device) {
        this.fileName = fileName;
        this.device = device;
    }

    private final class NetworkStats {
        private final long rxBytes;
        private final long rxPackets;
        private final long txBytes;
        private final long txPackets;

        @ConstructorProperties(value={"rxBytes", "rxPackets", "txBytes", "txPackets"})
        public NetworkStats(long rxBytes, long rxPackets, long txBytes, long txPackets) {
            this.rxBytes = rxBytes;
            this.rxPackets = rxPackets;
            this.txBytes = txBytes;
            this.txPackets = txPackets;
        }

        public long getRxBytes() {
            return this.rxBytes;
        }

        public long getRxPackets() {
            return this.rxPackets;
        }

        public long getTxBytes() {
            return this.txBytes;
        }

        public long getTxPackets() {
            return this.txPackets;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NetworkStats)) {
                return false;
            }
            NetworkStats other = (NetworkStats)o;
            if (this.getRxBytes() != other.getRxBytes()) {
                return false;
            }
            if (this.getRxPackets() != other.getRxPackets()) {
                return false;
            }
            if (this.getTxBytes() != other.getTxBytes()) {
                return false;
            }
            return this.getTxPackets() == other.getTxPackets();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $rxBytes = this.getRxBytes();
            result = result * 59 + (int)($rxBytes >>> 32 ^ $rxBytes);
            long $rxPackets = this.getRxPackets();
            result = result * 59 + (int)($rxPackets >>> 32 ^ $rxPackets);
            long $txBytes = this.getTxBytes();
            result = result * 59 + (int)($txBytes >>> 32 ^ $txBytes);
            long $txPackets = this.getTxPackets();
            result = result * 59 + (int)($txPackets >>> 32 ^ $txPackets);
            return result;
        }

        public String toString() {
            return "NetworkSubsystemProcess.NetworkStats(rxBytes=" + this.getRxBytes() + ", rxPackets=" + this.getRxPackets() + ", txBytes=" + this.getTxBytes() + ", txPackets=" + this.getTxPackets() + ")";
        }
    }
}

