/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.loader.cgroups;

import io.mantisrx.runtime.loader.cgroups.Cgroup;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import io.vavr.Tuple2;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class CgroupImpl
implements Cgroup {
    private final String path;
    private final AtomicReference<Object> old = new AtomicReference();
    private static final Set<String> knownSubsystems = new HashSet<String>(Arrays.asList("cpu", "cpuacct", "cpuset", "memory"));

    @Override
    public Boolean isV1() {
        return this.isOld();
    }

    @Override
    public List<Long> getMetrics(String subsystem, String metricName) throws IOException {
        Path metricPath = Paths.get(this.path, subsystem, metricName);
        try {
            return Files.readAllLines(metricPath).stream().findFirst().map(s -> Arrays.asList(s.split(" "))).orElse(Collections.emptyList()).stream().map(CgroupImpl::convertStringToLong).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public Long getMetric(String subsystem, String metricName) throws IOException {
        Path metricPath = Paths.get(this.path, subsystem, metricName);
        try {
            return Files.readAllLines(metricPath).stream().findFirst().map(CgroupImpl::convertStringToLong).get();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public Map<String, Long> getStats(String subsystem, String stat) throws IOException {
        Path statPath = Paths.get(this.path, subsystem, stat);
        return Files.readAllLines(statPath).stream().map(l -> {
            String[] parts = l.split("\\s+");
            Preconditions.checkArgument((parts.length == 2 ? 1 : 0) != 0, (String)"Expected two parts only but was {} parts", (int)parts.length);
            return new Tuple2((Object)parts[0], (Object)CgroupImpl.convertStringToLong(parts[1]));
        }).collect(Collectors.toMap(t -> (String)t._1, t -> (Long)t._2));
    }

    private static long convertStringToLong(String strval) {
        try {
            return Long.parseLong(strval);
        }
        catch (NumberFormatException e) {
            return Long.MAX_VALUE;
        }
    }

    private List<String> getSubsystems() {
        return Arrays.asList((Object[])Objects.requireNonNull(Paths.get(this.path, new String[0]).toFile().listFiles())).stream().filter(s -> s.isDirectory()).map(s -> s.getName()).filter(s -> knownSubsystems.contains(s)).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"path"})
    public CgroupImpl(String path) {
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOld() {
        Object value = this.old.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.old;
            synchronized (atomicReference) {
                value = this.old.get();
                if (value == null) {
                    boolean actualValue = this.getSubsystems().size() > 0;
                    value = actualValue;
                    this.old.set(value);
                }
            }
        }
        return (Boolean)value;
    }
}

