/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.loader.cgroups;

import io.mantisrx.runtime.loader.cgroups.Cgroup;
import io.mantisrx.runtime.loader.cgroups.SubsystemProcess;
import io.mantisrx.runtime.loader.config.Usage;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MemorySubsystemProcess
implements SubsystemProcess {
    private static final Logger log = LoggerFactory.getLogger(MemorySubsystemProcess.class);
    private final Cgroup cgroup;

    @Override
    public void getUsage(Usage.UsageBuilder usageBuilder) throws IOException {
        if (this.cgroup.isV1().booleanValue()) {
            this.handleV1(usageBuilder);
        } else {
            this.handleV2(usageBuilder);
        }
    }

    private void handleV1(Usage.UsageBuilder usageBuilder) throws IOException {
        Long memLimit = this.cgroup.getMetric("memory", "memory.limit_in_bytes");
        usageBuilder.memLimit(memLimit.longValue());
        Map<String, Long> stats = this.cgroup.getStats("memory", "memory.stat");
        Optional<Long> totalRss = Optional.ofNullable(stats.get("total_rss"));
        if (totalRss.isPresent()) {
            usageBuilder.memAnonBytes(totalRss.get().longValue());
            usageBuilder.memRssBytes(totalRss.get().longValue());
        } else {
            log.warn("stats for memory not found; stats={}", stats);
        }
    }

    private void handleV2(Usage.UsageBuilder usageBuilder) throws IOException {
        Long memLimit = this.cgroup.getMetric("", "memory.max");
        usageBuilder.memLimit(memLimit.longValue());
        Long memCurrent = this.cgroup.getMetric("", "memory.current");
        usageBuilder.memRssBytes(memCurrent.longValue());
        Map<String, Long> stats = this.cgroup.getStats("", "memory.stat");
        Optional<Long> anon = Optional.ofNullable(stats.get("anon"));
        if (anon.isPresent()) {
            usageBuilder.memAnonBytes(anon.get().longValue());
        } else {
            log.warn("stats for memory not found; stats={}", stats);
        }
    }

    @ConstructorProperties(value={"cgroup"})
    MemorySubsystemProcess(Cgroup cgroup) {
        this.cgroup = cgroup;
    }
}

