/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.loader.config;

import java.beans.ConstructorProperties;

public final class Usage {
    private final double cpusLimit;
    private final double cpusSystemTimeSecs;
    private final double cpusUserTimeSecs;
    private final double memLimit;
    private final double memRssBytes;
    private final double memAnonBytes;
    private final double networkReadBytes;
    private final double networkWriteBytes;

    public static UsageBuilder builder() {
        return new UsageBuilder();
    }

    public double getCpusLimit() {
        return this.cpusLimit;
    }

    public double getCpusSystemTimeSecs() {
        return this.cpusSystemTimeSecs;
    }

    public double getCpusUserTimeSecs() {
        return this.cpusUserTimeSecs;
    }

    public double getMemLimit() {
        return this.memLimit;
    }

    public double getMemRssBytes() {
        return this.memRssBytes;
    }

    public double getMemAnonBytes() {
        return this.memAnonBytes;
    }

    public double getNetworkReadBytes() {
        return this.networkReadBytes;
    }

    public double getNetworkWriteBytes() {
        return this.networkWriteBytes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Usage)) {
            return false;
        }
        Usage other = (Usage)o;
        if (Double.compare(this.getCpusLimit(), other.getCpusLimit()) != 0) {
            return false;
        }
        if (Double.compare(this.getCpusSystemTimeSecs(), other.getCpusSystemTimeSecs()) != 0) {
            return false;
        }
        if (Double.compare(this.getCpusUserTimeSecs(), other.getCpusUserTimeSecs()) != 0) {
            return false;
        }
        if (Double.compare(this.getMemLimit(), other.getMemLimit()) != 0) {
            return false;
        }
        if (Double.compare(this.getMemRssBytes(), other.getMemRssBytes()) != 0) {
            return false;
        }
        if (Double.compare(this.getMemAnonBytes(), other.getMemAnonBytes()) != 0) {
            return false;
        }
        if (Double.compare(this.getNetworkReadBytes(), other.getNetworkReadBytes()) != 0) {
            return false;
        }
        return Double.compare(this.getNetworkWriteBytes(), other.getNetworkWriteBytes()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $cpusLimit = Double.doubleToLongBits(this.getCpusLimit());
        result = result * 59 + (int)($cpusLimit >>> 32 ^ $cpusLimit);
        long $cpusSystemTimeSecs = Double.doubleToLongBits(this.getCpusSystemTimeSecs());
        result = result * 59 + (int)($cpusSystemTimeSecs >>> 32 ^ $cpusSystemTimeSecs);
        long $cpusUserTimeSecs = Double.doubleToLongBits(this.getCpusUserTimeSecs());
        result = result * 59 + (int)($cpusUserTimeSecs >>> 32 ^ $cpusUserTimeSecs);
        long $memLimit = Double.doubleToLongBits(this.getMemLimit());
        result = result * 59 + (int)($memLimit >>> 32 ^ $memLimit);
        long $memRssBytes = Double.doubleToLongBits(this.getMemRssBytes());
        result = result * 59 + (int)($memRssBytes >>> 32 ^ $memRssBytes);
        long $memAnonBytes = Double.doubleToLongBits(this.getMemAnonBytes());
        result = result * 59 + (int)($memAnonBytes >>> 32 ^ $memAnonBytes);
        long $networkReadBytes = Double.doubleToLongBits(this.getNetworkReadBytes());
        result = result * 59 + (int)($networkReadBytes >>> 32 ^ $networkReadBytes);
        long $networkWriteBytes = Double.doubleToLongBits(this.getNetworkWriteBytes());
        result = result * 59 + (int)($networkWriteBytes >>> 32 ^ $networkWriteBytes);
        return result;
    }

    public String toString() {
        return "Usage(cpusLimit=" + this.getCpusLimit() + ", cpusSystemTimeSecs=" + this.getCpusSystemTimeSecs() + ", cpusUserTimeSecs=" + this.getCpusUserTimeSecs() + ", memLimit=" + this.getMemLimit() + ", memRssBytes=" + this.getMemRssBytes() + ", memAnonBytes=" + this.getMemAnonBytes() + ", networkReadBytes=" + this.getNetworkReadBytes() + ", networkWriteBytes=" + this.getNetworkWriteBytes() + ")";
    }

    @ConstructorProperties(value={"cpusLimit", "cpusSystemTimeSecs", "cpusUserTimeSecs", "memLimit", "memRssBytes", "memAnonBytes", "networkReadBytes", "networkWriteBytes"})
    public Usage(double cpusLimit, double cpusSystemTimeSecs, double cpusUserTimeSecs, double memLimit, double memRssBytes, double memAnonBytes, double networkReadBytes, double networkWriteBytes) {
        this.cpusLimit = cpusLimit;
        this.cpusSystemTimeSecs = cpusSystemTimeSecs;
        this.cpusUserTimeSecs = cpusUserTimeSecs;
        this.memLimit = memLimit;
        this.memRssBytes = memRssBytes;
        this.memAnonBytes = memAnonBytes;
        this.networkReadBytes = networkReadBytes;
        this.networkWriteBytes = networkWriteBytes;
    }

    public static class UsageBuilder {
        private double cpusLimit;
        private double cpusSystemTimeSecs;
        private double cpusUserTimeSecs;
        private double memLimit;
        private double memRssBytes;
        private double memAnonBytes;
        private double networkReadBytes;
        private double networkWriteBytes;

        UsageBuilder() {
        }

        public UsageBuilder cpusLimit(double cpusLimit) {
            this.cpusLimit = cpusLimit;
            return this;
        }

        public UsageBuilder cpusSystemTimeSecs(double cpusSystemTimeSecs) {
            this.cpusSystemTimeSecs = cpusSystemTimeSecs;
            return this;
        }

        public UsageBuilder cpusUserTimeSecs(double cpusUserTimeSecs) {
            this.cpusUserTimeSecs = cpusUserTimeSecs;
            return this;
        }

        public UsageBuilder memLimit(double memLimit) {
            this.memLimit = memLimit;
            return this;
        }

        public UsageBuilder memRssBytes(double memRssBytes) {
            this.memRssBytes = memRssBytes;
            return this;
        }

        public UsageBuilder memAnonBytes(double memAnonBytes) {
            this.memAnonBytes = memAnonBytes;
            return this;
        }

        public UsageBuilder networkReadBytes(double networkReadBytes) {
            this.networkReadBytes = networkReadBytes;
            return this;
        }

        public UsageBuilder networkWriteBytes(double networkWriteBytes) {
            this.networkWriteBytes = networkWriteBytes;
            return this;
        }

        public Usage build() {
            return new Usage(this.cpusLimit, this.cpusSystemTimeSecs, this.cpusUserTimeSecs, this.memLimit, this.memRssBytes, this.memAnonBytes, this.networkReadBytes, this.networkWriteBytes);
        }

        public String toString() {
            return "Usage.UsageBuilder(cpusLimit=" + this.cpusLimit + ", cpusSystemTimeSecs=" + this.cpusSystemTimeSecs + ", cpusUserTimeSecs=" + this.cpusUserTimeSecs + ", memLimit=" + this.memLimit + ", memRssBytes=" + this.memRssBytes + ", memAnonBytes=" + this.memAnonBytes + ", networkReadBytes=" + this.networkReadBytes + ", networkWriteBytes=" + this.networkWriteBytes + ")";
        }
    }
}

