/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.loader;

import io.mantisrx.runtime.loader.SubscriptionStateHandlerImpl;
import io.mantisrx.server.core.ExecuteStageRequest;
import io.mantisrx.server.master.client.MantisMasterGateway;
import io.mantisrx.shaded.com.google.common.util.concurrent.AbstractIdleService;
import io.mantisrx.shaded.com.google.common.util.concurrent.Service;
import java.time.Clock;
import java.util.function.Function;

public interface SinkSubscriptionStateHandler
extends Service {
    public static final SinkSubscriptionStateHandler NOOP_INSTANCE = new NoopSinkSubscriptionStateHandler();

    public void onSinkSubscribed();

    public void onSinkUnsubscribed();

    public static SinkSubscriptionStateHandler noop() {
        return NOOP_INSTANCE;
    }

    public static class NoopSinkSubscriptionStateHandler
    extends AbstractIdleService
    implements SinkSubscriptionStateHandler {
        @Override
        public void onSinkSubscribed() {
        }

        @Override
        public void onSinkUnsubscribed() {
        }

        protected void startUp() throws Exception {
        }

        protected void shutDown() throws Exception {
        }
    }

    public static interface Factory
    extends Function<ExecuteStageRequest, SinkSubscriptionStateHandler> {
        public static Factory forEphemeralJobsThatNeedToBeKilledInAbsenceOfSubscriber(MantisMasterGateway gateway, Clock clock) {
            return executeStageRequest -> {
                if (executeStageRequest.getSubscriptionTimeoutSecs() > 0L) {
                    return new SubscriptionStateHandlerImpl(executeStageRequest.getJobId(), gateway, executeStageRequest.getSubscriptionTimeoutSecs(), executeStageRequest.getMinRuntimeSecs(), clock);
                }
                return NOOP_INSTANCE;
            };
        }
    }
}

