/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.loader.config;

import io.mantisrx.common.JsonSerializer;
import io.mantisrx.runtime.loader.config.MetricsCollector;
import io.mantisrx.runtime.loader.config.WorkerConfiguration;
import io.mantisrx.runtime.loader.config.WorkerConfigurationWritable;
import io.mantisrx.server.core.MetricsCoercer;
import io.mantisrx.server.master.client.config.PluginCoercible;
import java.io.IOException;
import java.util.Properties;
import org.skife.config.Coercible;
import org.skife.config.ConfigurationObjectFactory;

public class WorkerConfigurationUtils {
    public static <T extends WorkerConfiguration> T frmProperties(Properties properties, Class<T> tClass) {
        ConfigurationObjectFactory configurationObjectFactory = new ConfigurationObjectFactory(properties);
        configurationObjectFactory.addCoercible((Coercible)new MetricsCoercer(properties));
        configurationObjectFactory.addCoercible((Coercible)new PluginCoercible(MetricsCollector.class, properties));
        return (T)((WorkerConfiguration)configurationObjectFactory.build(tClass));
    }

    public static <T extends WorkerConfiguration> WorkerConfigurationWritable toWritable(T configSource) {
        return WorkerConfigurationWritable.builder().bindAddress(configSource.getBindAddress()).bindPort(configSource.getBindPort()).blobStoreArtifactDir(configSource.getBlobStoreArtifactDir()).consolePort(configSource.getConsolePort()).clusterId(configSource.getClusterId()).customPort(configSource.getCustomPort()).debugPort(configSource.getDebugPort()).externalAddress(configSource.getExternalAddress()).externalPortRange(configSource.getExternalPortRange()).heartbeatInternalInMs(configSource.heartbeatInternalInMs()).heartbeatTimeoutMs(configSource.heartbeatTimeoutMs()).isLocalMode(configSource.isLocalMode()).leaderAnnouncementPath(configSource.getLeaderAnnouncementPath()).localStorageDir(configSource.getLocalStorageDir()).mesosSlavePort(configSource.getMesosSlavePort()).metricsCollector(configSource.getUsageSupplier()).metricsPort(configSource.getMetricsPort()).metricsPublisher(configSource.getMetricsPublisher()).metricsPublisherFrequencyInSeconds(configSource.getMetricsPublisherFrequencyInSeconds()).networkBandwidthInMB(configSource.getNetworkBandwidthInMB()).sinkPort(configSource.getSinkPort()).taskExecutorId(configSource.getTaskExecutorId()).taskExecutorAttributesStr(configSource.taskExecutorAttributes()).zkConnectionMaxRetries(configSource.getZkConnectionMaxRetries()).zkConnectionTimeoutMs(configSource.getZkConnectionTimeoutMs()).zkConnectionString(configSource.getZkConnectionString()).zkConnectionRetrySleepMs(configSource.getZkConnectionRetrySleepMs()).zkRoot(configSource.getZkRoot()).build();
    }

    public static WorkerConfigurationWritable stringToWorkerConfiguration(String sourceStr) throws IOException {
        JsonSerializer ser = new JsonSerializer();
        return (WorkerConfigurationWritable)ser.fromJSON(sourceStr, WorkerConfigurationWritable.class);
    }
}

