/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.loader;

import io.mantisrx.server.core.ExecuteStageRequest;
import io.mantisrx.shaded.com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import org.apache.flink.util.SimpleUserCodeClassLoader;
import org.apache.flink.util.UserCodeClassLoader;

public interface ClassLoaderHandle
extends Closeable {
    public UserCodeClassLoader getOrResolveClassLoader(Collection<URI> var1, Collection<URL> var2) throws IOException;

    public static ClassLoaderHandle fixed(final ClassLoader classLoader) {
        return new ClassLoaderHandle(){

            @Override
            public UserCodeClassLoader getOrResolveClassLoader(Collection<URI> requiredJarFiles, Collection<URL> requiredClasspaths) throws IOException {
                return SimpleUserCodeClassLoader.create((ClassLoader)classLoader);
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    default public UserCodeClassLoader createUserCodeClassloader(ExecuteStageRequest executeStageRequest) throws Exception {
        UserCodeClassLoader userCodeClassLoader = this.getOrResolveClassLoader((Collection<URI>)ImmutableList.of((Object)executeStageRequest.getJobJarUrl().toURI()), (Collection<URL>)ImmutableList.of());
        return userCodeClassLoader;
    }
}

