/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.loader;

import io.mantisrx.runtime.loader.SinkSubscriptionStateHandler;
import io.mantisrx.server.master.client.MantisMasterGateway;
import io.mantisrx.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.com.google.common.util.concurrent.AbstractScheduledService;
import java.beans.ConstructorProperties;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SubscriptionStateHandlerImpl
extends AbstractScheduledService
implements SinkSubscriptionStateHandler {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionStateHandlerImpl.class);
    private final String jobId;
    private final MantisMasterGateway masterClientApi;
    private final Duration subscriptionTimeout;
    private final Duration minRuntime;
    private final AtomicReference<SubscriptionState> currentState = new AtomicReference();
    private final Clock clock;

    SubscriptionStateHandlerImpl(String jobId, MantisMasterGateway masterClientApi, long subscriptionTimeoutSecs, long minRuntimeSecs, Clock clock) {
        Preconditions.checkArgument((subscriptionTimeoutSecs > 0L ? 1 : 0) != 0, (Object)"subscriptionTimeoutSecs should be > 0");
        this.jobId = jobId;
        this.masterClientApi = masterClientApi;
        this.subscriptionTimeout = Duration.ofSeconds(subscriptionTimeoutSecs);
        this.minRuntime = Duration.ofSeconds(minRuntimeSecs);
        this.clock = clock;
    }

    public void startUp() {
        this.currentState.compareAndSet(null, SubscriptionState.of(this.clock));
        log.info("SubscriptionStateHandlerImpl service started.");
    }

    protected AbstractScheduledService.Scheduler scheduler() {
        return AbstractScheduledService.Scheduler.newFixedDelaySchedule((long)1L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
    }

    protected void runOneIteration() {
        SubscriptionState state = this.currentState.get();
        if (state.isUnsubscribedFor(this.subscriptionTimeout) && state.hasRunFor(this.minRuntime)) {
            try {
                log.info("Calling master to kill due to subscription timeout");
                this.masterClientApi.killJob(this.jobId, "MantisWorker", "No subscriptions for " + this.subscriptionTimeout.getSeconds() + " secs").single().toBlocking().first();
            }
            catch (Exception e) {
                log.error("Failed to kill job {} due to no subscribers for {} seconds", (Object)this.jobId, (Object)state.getUnsubscribedDuration().getSeconds());
            }
        }
    }

    @Override
    public void onSinkUnsubscribed() {
        if (this.currentState.get() == null) {
            log.error("currentState in SubscriptionStateHandlerImpl is not set onSinkUnsubscribed");
            return;
        }
        this.currentState.updateAndGet(SubscriptionState::onSinkUnsubscribed);
    }

    @Override
    public void onSinkSubscribed() {
        Preconditions.checkNotNull((Object)this.currentState.get(), (Object)"currentState is not intialized onSinkSubscribed.");
        this.currentState.updateAndGet(SubscriptionState::onSinkSubscribed);
    }

    static final class SubscriptionState {
        private final boolean subscribed;
        private final Instant startedAt;
        private final Instant lastUnsubscriptionTime;
        private final Clock clock;

        static SubscriptionState of(Clock clock) {
            return new SubscriptionState(false, clock.instant(), clock.instant(), clock);
        }

        public SubscriptionState onSinkSubscribed() {
            if (this.isSubscribed()) {
                return this;
            }
            return new SubscriptionState(true, this.startedAt, this.lastUnsubscriptionTime, this.clock);
        }

        public SubscriptionState onSinkUnsubscribed() {
            if (this.isSubscribed()) {
                return new SubscriptionState(false, this.startedAt, this.clock.instant(), this.clock);
            }
            return this;
        }

        public boolean hasRunFor(Duration duration) {
            return Duration.between(this.startedAt, this.clock.instant()).compareTo(duration) >= 0;
        }

        public boolean isUnsubscribedFor(Duration duration) {
            return !this.isSubscribed() && Duration.between(this.lastUnsubscriptionTime, this.clock.instant()).compareTo(duration) >= 0;
        }

        public Duration getUnsubscribedDuration() {
            Preconditions.checkState((!this.isSubscribed() ? 1 : 0) != 0);
            return Duration.between(this.lastUnsubscriptionTime, this.clock.instant());
        }

        public boolean isSubscribed() {
            return this.subscribed;
        }

        public Instant getStartedAt() {
            return this.startedAt;
        }

        public Instant getLastUnsubscriptionTime() {
            return this.lastUnsubscriptionTime;
        }

        public Clock getClock() {
            return this.clock;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubscriptionState)) {
                return false;
            }
            SubscriptionState other = (SubscriptionState)o;
            if (this.isSubscribed() != other.isSubscribed()) {
                return false;
            }
            Instant this$startedAt = this.getStartedAt();
            Instant other$startedAt = other.getStartedAt();
            if (this$startedAt == null ? other$startedAt != null : !((Object)this$startedAt).equals(other$startedAt)) {
                return false;
            }
            Instant this$lastUnsubscriptionTime = this.getLastUnsubscriptionTime();
            Instant other$lastUnsubscriptionTime = other.getLastUnsubscriptionTime();
            if (this$lastUnsubscriptionTime == null ? other$lastUnsubscriptionTime != null : !((Object)this$lastUnsubscriptionTime).equals(other$lastUnsubscriptionTime)) {
                return false;
            }
            Clock this$clock = this.getClock();
            Clock other$clock = other.getClock();
            return !(this$clock == null ? other$clock != null : !((Object)this$clock).equals(other$clock));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSubscribed() ? 79 : 97);
            Instant $startedAt = this.getStartedAt();
            result = result * 59 + ($startedAt == null ? 43 : ((Object)$startedAt).hashCode());
            Instant $lastUnsubscriptionTime = this.getLastUnsubscriptionTime();
            result = result * 59 + ($lastUnsubscriptionTime == null ? 43 : ((Object)$lastUnsubscriptionTime).hashCode());
            Clock $clock = this.getClock();
            result = result * 59 + ($clock == null ? 43 : ((Object)$clock).hashCode());
            return result;
        }

        public String toString() {
            return "SubscriptionStateHandlerImpl.SubscriptionState(subscribed=" + this.isSubscribed() + ", startedAt=" + this.getStartedAt() + ", lastUnsubscriptionTime=" + this.getLastUnsubscriptionTime() + ", clock=" + this.getClock() + ")";
        }

        @ConstructorProperties(value={"subscribed", "startedAt", "lastUnsubscriptionTime", "clock"})
        private SubscriptionState(boolean subscribed, Instant startedAt, Instant lastUnsubscriptionTime, Clock clock) {
            this.subscribed = subscribed;
            this.startedAt = startedAt;
            this.lastUnsubscriptionTime = lastUnsubscriptionTime;
            this.clock = clock;
        }
    }
}

