/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.loader.config;

import io.mantisrx.runtime.loader.config.MetricsCollector;
import io.mantisrx.server.core.CoreConfiguration;
import io.mantisrx.shaded.com.google.common.base.Splitter;
import io.mantisrx.shaded.com.google.common.collect.ImmutableMap;
import java.io.File;
import java.net.URI;
import java.util.Map;
import org.apache.flink.api.common.time.Time;
import org.skife.config.Config;
import org.skife.config.Default;
import org.skife.config.DefaultNull;

public interface WorkerConfiguration
extends CoreConfiguration {
    @Config(value={"mantis.agent.mesos.slave.port"})
    @Default(value="5051")
    public int getMesosSlavePort();

    @Config(value={"mantis.taskexecutor.id"})
    @DefaultNull
    public String getTaskExecutorId();

    default public String getTaskExecutorHostName() {
        return this.getExternalAddress();
    }

    @Config(value={"mantis.taskexecutor.cluster-id"})
    @Default(value="DEFAULT_CLUSTER")
    public String getClusterId();

    @Config(value={"mantis.taskexecutor.ports.metrics"})
    @Default(value="5051")
    public int getMetricsPort();

    @Config(value={"mantis.taskexecutor.ports.debug"})
    @Default(value="5052")
    public int getDebugPort();

    @Config(value={"mantis.taskexecutor.ports.console"})
    @Default(value="5053")
    public int getConsolePort();

    @Config(value={"mantis.taskexecutor.ports.custom"})
    @Default(value="5054")
    public int getCustomPort();

    @Config(value={"mantis.taskexecutor.ports.sink"})
    @Default(value="5055")
    public int getSinkPort();

    @Config(value={"mantis.taskexecutor.heartbeats.interval"})
    @Default(value="10000")
    public int heartbeatInternalInMs();

    @Config(value={"mantis.taskexecutor.heartbeats.tolerable-consecutive-heartbeat-failures"})
    @Default(value="3")
    public int getTolerableConsecutiveHeartbeatFailures();

    @Config(value={"mantis.taskexecutor.heartbeats.timeout.ms"})
    @Default(value="5000")
    public int heartbeatTimeoutMs();

    default public Time getHeartbeatTimeout() {
        return Time.milliseconds((long)this.heartbeatTimeoutMs());
    }

    default public Time getHeartbeatInterval() {
        return Time.milliseconds((long)this.heartbeatInternalInMs());
    }

    @Config(value={"mantis.taskexecutor.rpc.external-address"})
    @Default(value="${EC2_LOCAL_IPV4}")
    public String getExternalAddress();

    @Config(value={"mantis.taskexecutor.rpc.port-range"})
    @Default(value="")
    public String getExternalPortRange();

    @Config(value={"mantis.taskexecutor.rpc.bind-address"})
    @DefaultNull
    public String getBindAddress();

    @Config(value={"mantis.taskexecutor.rpc.bind-port"})
    @DefaultNull
    public Integer getBindPort();

    @Config(value={"mantis.taskexecutor.metrics.collector"})
    @Default(value="io.mantisrx.server.worker.mesos.MesosMetricsCollector")
    public MetricsCollector getUsageSupplier();

    @Config(value={"mantis.taskexecutor.blob-store.storage-dir"})
    @DefaultNull
    public URI getBlobStoreArtifactDir();

    @Config(value={"mantis.taskexecutor.blob-store.local-cache"})
    @DefaultNull
    public File getLocalStorageDir();

    @Config(value={"mantis.taskexecutor.hardware.network-bandwidth-in-mb"})
    @Default(value="128.0")
    public double getNetworkBandwidthInMB();

    @Config(value={"mantis.taskexecutor.attributes"})
    @Default(value="")
    public String taskExecutorAttributes();

    default public Map<String, String> getTaskExecutorAttributes() {
        String input = this.taskExecutorAttributes();
        if (input == null || input.isEmpty()) {
            return ImmutableMap.of();
        }
        return Splitter.on((String)",").withKeyValueSeparator(':').split((CharSequence)input);
    }
}

