/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.worker.jobmaster.control;

import io.mantisrx.runtime.descriptor.StageScalingPolicy;
import io.mantisrx.shaded.com.fasterxml.jackson.core.type.TypeReference;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.io.IOException;

public class AdaptiveAutoscalerConfig {
    public final StageScalingPolicy.ScalingReason metric;
    public final double setPoint;
    public final boolean invert;
    public final double rope;
    public final double kp;
    public final double ki;
    public final double kd;
    public final double minScale;
    public final double maxScale;

    @ConstructorProperties(value={"metric", "setPoint", "invert", "rope", "kp", "ki", "kd", "minScale", "maxScale"})
    public AdaptiveAutoscalerConfig(StageScalingPolicy.ScalingReason metric, double setPoint, boolean invert, double rope, double kp, double ki, double kd, double minScale, double maxScale) {
        this.metric = metric;
        this.setPoint = setPoint;
        this.invert = invert;
        this.rope = rope;
        this.kp = kp;
        this.ki = ki;
        this.kd = kd;
        this.minScale = minScale;
        this.maxScale = maxScale;
    }

    public static void main(String[] args) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        String cfg = "{\"metric\": \"KafkaProcessed\", \"setPoint\": 1, \"invert\": true, \"rope\": 0, \"kp\": 0.1, \"ki\": 0.00, \"kd\": 0.00, \"minScale\": 1, \"maxScale\": 5}\n";
        AdaptiveAutoscalerConfig config = (AdaptiveAutoscalerConfig)objectMapper.readValue(cfg, (TypeReference)new TypeReference<AdaptiveAutoscalerConfig>(){});
        System.out.println(config.toString());
    }

    public StageScalingPolicy.ScalingReason getMetric() {
        return this.metric;
    }

    public double getSetPoint() {
        return this.setPoint;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public double getRope() {
        return this.rope;
    }

    public double getKp() {
        return this.kp;
    }

    public double getKi() {
        return this.ki;
    }

    public double getKd() {
        return this.kd;
    }

    public double getMinScale() {
        return this.minScale;
    }

    public double getMaxScale() {
        return this.maxScale;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdaptiveAutoscalerConfig)) {
            return false;
        }
        AdaptiveAutoscalerConfig other = (AdaptiveAutoscalerConfig)o;
        StageScalingPolicy.ScalingReason this$metric = this.getMetric();
        StageScalingPolicy.ScalingReason other$metric = other.getMetric();
        if (this$metric == null ? other$metric != null : !this$metric.equals(other$metric)) {
            return false;
        }
        if (Double.compare(this.getSetPoint(), other.getSetPoint()) != 0) {
            return false;
        }
        if (this.isInvert() != other.isInvert()) {
            return false;
        }
        if (Double.compare(this.getRope(), other.getRope()) != 0) {
            return false;
        }
        if (Double.compare(this.getKp(), other.getKp()) != 0) {
            return false;
        }
        if (Double.compare(this.getKi(), other.getKi()) != 0) {
            return false;
        }
        if (Double.compare(this.getKd(), other.getKd()) != 0) {
            return false;
        }
        if (Double.compare(this.getMinScale(), other.getMinScale()) != 0) {
            return false;
        }
        return Double.compare(this.getMaxScale(), other.getMaxScale()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StageScalingPolicy.ScalingReason $metric = this.getMetric();
        result = result * 59 + ($metric == null ? 43 : $metric.hashCode());
        long $setPoint = Double.doubleToLongBits(this.getSetPoint());
        result = result * 59 + (int)($setPoint >>> 32 ^ $setPoint);
        result = result * 59 + (this.isInvert() ? 79 : 97);
        long $rope = Double.doubleToLongBits(this.getRope());
        result = result * 59 + (int)($rope >>> 32 ^ $rope);
        long $kp = Double.doubleToLongBits(this.getKp());
        result = result * 59 + (int)($kp >>> 32 ^ $kp);
        long $ki = Double.doubleToLongBits(this.getKi());
        result = result * 59 + (int)($ki >>> 32 ^ $ki);
        long $kd = Double.doubleToLongBits(this.getKd());
        result = result * 59 + (int)($kd >>> 32 ^ $kd);
        long $minScale = Double.doubleToLongBits(this.getMinScale());
        result = result * 59 + (int)($minScale >>> 32 ^ $minScale);
        long $maxScale = Double.doubleToLongBits(this.getMaxScale());
        result = result * 59 + (int)($maxScale >>> 32 ^ $maxScale);
        return result;
    }

    public String toString() {
        return "AdaptiveAutoscalerConfig(metric=" + this.getMetric() + ", setPoint=" + this.getSetPoint() + ", invert=" + this.isInvert() + ", rope=" + this.getRope() + ", kp=" + this.getKp() + ", ki=" + this.getKi() + ", kd=" + this.getKd() + ", minScale=" + this.getMinScale() + ", maxScale=" + this.getMaxScale() + ")";
    }
}

