/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.worker.jobmaster.clutch.experimental;

import com.yahoo.sketches.quantiles.UpdateDoublesSketch;
import io.mantisrx.control.clutch.Clutch;
import io.mantisrx.control.clutch.ClutchConfiguration;
import io.mantisrx.runtime.descriptor.StageSchedulingInfo;
import io.mantisrx.shaded.com.google.common.util.concurrent.AtomicDouble;
import io.vavr.Function1;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MantisClutchConfigurationSelector
implements Function1<Map<Clutch.Metric, UpdateDoublesSketch>, ClutchConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(MantisClutchConfigurationSelector.class);
    private final Integer stageNumber;
    private final StageSchedulingInfo stageSchedulingInfo;
    private final AtomicDouble trueCpuMax = new AtomicDouble(0.0);
    private final AtomicDouble trueNetworkMax = new AtomicDouble(0.0);
    private final AtomicDouble trueCpuMin = new AtomicDouble(0.0);
    private final AtomicDouble trueNetworkMin = new AtomicDouble(0.0);
    private final long initializationTime = System.currentTimeMillis();
    private final long ONE_DAY_MILLIS = 86400000L;
    private final long TEN_MINUTES_MILLIS = 600000L;

    public MantisClutchConfigurationSelector(Integer stageNumber, StageSchedulingInfo stageSchedulingInfo) {
        this.stageNumber = stageNumber;
        this.stageSchedulingInfo = stageSchedulingInfo;
    }

    private double getSetpoint(Map<Clutch.Metric, UpdateDoublesSketch> sketches, double numberOfCpuCores) {
        double setPoint = sketches.get(Clutch.Metric.RPS).getQuantile(0.75);
        double minRps = 1000.0 * numberOfCpuCores;
        double maxRps = 2500.0 * numberOfCpuCores;
        if (this.isSetpointHigh(sketches) && System.currentTimeMillis() - this.initializationTime > 85800000L) {
            setPoint *= 0.9;
        } else if (this.isSetpointLow(sketches) && System.currentTimeMillis() - this.initializationTime > 85800000L) {
            setPoint *= 1.11;
        }
        if (this.isUnderprovisioined(sketches) && System.currentTimeMillis() - this.initializationTime > 86400000L) {
            logger.info("Job is underprovisioned see previous messages to determine metric.");
        }
        if (setPoint < minRps) {
            logger.info("Setpoint {} was less than minimum {}. Setting to {}.", (Object)minRps, (Object)minRps);
            setPoint = minRps;
        }
        if (setPoint > maxRps) {
            logger.info("Setpoint {} was greater than maximum {}. Setting to {}.", (Object)maxRps, (Object)maxRps);
            setPoint = maxRps;
        }
        return setPoint;
    }

    public ClutchConfiguration apply(Map<Clutch.Metric, UpdateDoublesSketch> sketches) {
        this.updateTrueMaxValues(sketches);
        double numberOfCpuCores = this.stageSchedulingInfo.getMachineDefinition().getCpuCores();
        double setPoint = this.getSetpoint(sketches, numberOfCpuCores);
        Tuple2 rope = Tuple.of((Object)(setPoint * 0.3), (Object)0.0);
        long deltaT = this.stageSchedulingInfo.getScalingPolicy().getCoolDownSecs() / 30L;
        double dampeningFactor = 0.33;
        double kp = 1.0 / setPoint / (double)deltaT * (double)this.stageSchedulingInfo.getScalingPolicy().getMin();
        double ki = 0.0 * dampeningFactor;
        double kd = 1.0 / setPoint / (double)deltaT * (double)this.stageSchedulingInfo.getScalingPolicy().getMin();
        return ClutchConfiguration.builder().metric(Clutch.Metric.RPS).setPoint(setPoint).kp(kp).ki(ki).kd(kd).minSize(this.stageSchedulingInfo.getScalingPolicy().getMin()).maxSize(this.stageSchedulingInfo.getScalingPolicy().getMax()).rope(rope).cooldownInterval(this.stageSchedulingInfo.getScalingPolicy().getCoolDownSecs()).cooldownUnits(TimeUnit.SECONDS).build();
    }

    private void resetSketches(Map<Clutch.Metric, UpdateDoublesSketch> sketches) {
        sketches.values().forEach(UpdateDoublesSketch::reset);
    }

    private boolean isSetpointLow(Map<Clutch.Metric, UpdateDoublesSketch> sketches) {
        boolean networkTooLow;
        double cpuMedian = sketches.get(Clutch.Metric.CPU).getQuantile(0.5);
        double networkMedian = sketches.get(Clutch.Metric.NETWORK).getQuantile(0.5);
        boolean cpuTooLow = cpuMedian < this.trueCpuMax.get() * 0.5;
        boolean bl = networkTooLow = networkMedian < this.trueNetworkMax.get() * 0.5;
        if (cpuTooLow) {
            logger.info("CPU running too cold for stage {} with median {} and max {}. Recommending increase in setPoint.", new Object[]{this.stageNumber, cpuMedian, this.trueCpuMax.get()});
        }
        if (networkTooLow) {
            logger.info("Network running too cold for stage {} with median {} and max {}. Recommending increase in setPoint.", new Object[]{this.stageNumber, networkMedian, this.trueNetworkMax.get()});
        }
        return cpuTooLow || networkTooLow;
    }

    private boolean isSetpointHigh(Map<Clutch.Metric, UpdateDoublesSketch> sketches) {
        boolean networkTooHigh;
        double cpuMedian = sketches.get(Clutch.Metric.CPU).getQuantile(0.5);
        double networkMedian = sketches.get(Clutch.Metric.NETWORK).getQuantile(0.5);
        boolean cpuTooHigh = cpuMedian > this.trueCpuMax.get() * 0.8 && cpuMedian > this.trueCpuMin.get() * 1.2;
        boolean bl = networkTooHigh = networkMedian > this.trueNetworkMax.get() * 0.8 && networkMedian > this.trueNetworkMin.get() * 1.2;
        if (cpuTooHigh) {
            logger.info("CPU running too hot for stage {} with median {} and max {}. Recommending reduction in setPoint.", new Object[]{this.stageNumber, cpuMedian, this.trueCpuMax.get()});
        }
        if (networkTooHigh) {
            logger.info("Network running too hot for stage {} with median {} and max {}. Recommending reduction in setPoint.", new Object[]{this.stageNumber, cpuMedian, this.trueNetworkMax.get()});
        }
        return cpuTooHigh || networkTooHigh;
    }

    private boolean isUnderprovisioined(Map<Clutch.Metric, UpdateDoublesSketch> sketches) {
        boolean networkUnderProvisioned;
        double provisionedCpuLimit = this.stageSchedulingInfo.getMachineDefinition().getCpuCores() * 100.0;
        double provisionedNetworkLimit = this.stageSchedulingInfo.getMachineDefinition().getNetworkMbps() * 1024.0 * 1024.0;
        double cpu = sketches.get(Clutch.Metric.CPU).getQuantile(0.8);
        double network = sketches.get(Clutch.Metric.NETWORK).getQuantile(0.8);
        boolean cpuUnderProvisioned = cpu > provisionedCpuLimit;
        boolean bl = networkUnderProvisioned = network > provisionedNetworkLimit;
        if (cpuUnderProvisioned) {
            logger.error("CPU is underprovisioned! 80% percentile {}% is above provisioned {}%.", (Object)cpu, (Object)provisionedCpuLimit);
        }
        if (networkUnderProvisioned) {
            logger.error("Network is underprovisioned! 80% percentile {}% is above provisioned {}%.", (Object)network, (Object)provisionedNetworkLimit);
        }
        return cpuUnderProvisioned || networkUnderProvisioned;
    }

    private void updateTrueMaxValues(Map<Clutch.Metric, UpdateDoublesSketch> sketches) {
        double cpuMax = sketches.get(Clutch.Metric.CPU).getMaxValue();
        double networkMax = sketches.get(Clutch.Metric.NETWORK).getMaxValue();
        if (cpuMax > this.trueCpuMax.get()) {
            this.trueCpuMax.set(cpuMax);
        }
        if (networkMax > this.trueNetworkMax.get()) {
            this.trueNetworkMax.set(networkMax);
        }
        double cpuMin = sketches.get(Clutch.Metric.CPU).getMinValue();
        double networkMin = sketches.get(Clutch.Metric.NETWORK).getMinValue();
        if (cpuMin < this.trueCpuMin.get()) {
            this.trueCpuMin.set(cpuMin);
        }
        if (networkMin < this.trueNetworkMin.get()) {
            this.trueNetworkMin.set(networkMin);
        }
    }
}

