/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.worker.jobmaster;

import io.mantisrx.common.MantisServerSentEvent;
import io.mantisrx.common.metrics.measurement.GaugeMeasurement;
import io.mantisrx.common.metrics.measurement.Measurements;
import io.mantisrx.runtime.Context;
import io.mantisrx.runtime.descriptor.SchedulingInfo;
import io.mantisrx.runtime.parameter.SourceJobParameters;
import io.mantisrx.server.core.Service;
import io.mantisrx.server.master.client.MantisMasterGateway;
import io.mantisrx.server.worker.client.WorkerMetricsClient;
import io.mantisrx.server.worker.jobmaster.AutoScaleMetricsConfig;
import io.mantisrx.server.worker.jobmaster.JobAutoScaler;
import io.mantisrx.server.worker.jobmaster.JobAutoscalerManager;
import io.mantisrx.server.worker.jobmaster.MetricData;
import io.mantisrx.server.worker.jobmaster.SourceJobWorkerMetricsSubscription;
import io.mantisrx.server.worker.jobmaster.WorkerMetricHandler;
import io.mantisrx.server.worker.jobmaster.WorkerMetricSubscription;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Action1;

public class JobMasterService
implements Service {
    private static final Logger logger = LoggerFactory.getLogger(JobMasterService.class);
    private static final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final String jobId;
    private final WorkerMetricsClient workerMetricsClient;
    private final AutoScaleMetricsConfig autoScaleMetricsConfig;
    private final Observer<MetricData> metricObserver;
    private final JobAutoScaler jobAutoScaler;
    private final Context context;
    private final Action0 observableOnCompleteCallback;
    private final Action1<Throwable> observableOnErrorCallback;
    private final Action0 observableOnTerminateCallback;
    private final MantisMasterGateway masterClientApi;
    private Subscription subscription = null;

    public JobMasterService(String jobId, SchedulingInfo schedInfo, WorkerMetricsClient workerMetricsClient, AutoScaleMetricsConfig autoScaleMetricsConfig, MantisMasterGateway masterClientApi, Context context, Action0 observableOnCompleteCallback, Action1<Throwable> observableOnErrorCallback, Action0 observableOnTerminateCallback, JobAutoscalerManager jobAutoscalerManager) {
        this.jobId = jobId;
        this.workerMetricsClient = workerMetricsClient;
        this.autoScaleMetricsConfig = autoScaleMetricsConfig;
        this.masterClientApi = masterClientApi;
        this.jobAutoScaler = new JobAutoScaler(jobId, schedInfo, masterClientApi, context, jobAutoscalerManager);
        this.metricObserver = new WorkerMetricHandler(jobId, this.jobAutoScaler.getObserver(), masterClientApi, autoScaleMetricsConfig, jobAutoscalerManager).initAndGetMetricDataObserver();
        this.observableOnCompleteCallback = observableOnCompleteCallback;
        this.observableOnErrorCallback = observableOnErrorCallback;
        this.observableOnTerminateCallback = observableOnTerminateCallback;
        this.context = context;
    }

    private Measurements handleMetricEvent(String ev) {
        try {
            Measurements measurements = (Measurements)objectMapper.readValue(ev, Measurements.class);
            String jobId = (String)measurements.getTags().get("mantisJobId");
            int workerIdx = Integer.parseInt((String)measurements.getTags().get("mantisWorkerIndex"));
            int stage = Integer.parseInt((String)measurements.getTags().get("mantisStageNum"));
            int workerNum = Integer.parseInt((String)measurements.getTags().get("mantisWorkerNum"));
            List gauges = (List)measurements.getGauges();
            if (jobId != this.jobId) {
                stage = 1;
                if (gauges.isEmpty()) {
                    gauges = measurements.getCounters().stream().map(counter -> new GaugeMeasurement(counter.getEvent(), (double)counter.getCount())).collect(Collectors.toList());
                }
            }
            this.metricObserver.onNext((Object)new MetricData(jobId, stage, workerIdx, workerNum, measurements.getName(), gauges));
            return measurements;
        }
        catch (JsonProcessingException e) {
            logger.error("failed to parse json", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("caught exception", (Throwable)e);
        }
        return null;
    }

    public void start() {
        logger.info("Starting JobMasterService");
        logger.info("Starting Job Auto Scaler");
        this.jobAutoScaler.start();
        WorkerMetricSubscription workerMetricSubscription = new WorkerMetricSubscription(this.jobId, this.workerMetricsClient, this.autoScaleMetricsConfig.getMetricGroups());
        Observable metrics = workerMetricSubscription.getMetricsClient().getResults();
        boolean isSourceJobMetricEnabled = (Boolean)this.context.getParameters().get("mantis.jobmaster.autoscale.sourcejob.metric.enabled", (Object)false);
        if (isSourceJobMetricEnabled) {
            metrics = metrics.mergeWith(this.getSourceJobMetrics());
        }
        this.subscription = Observable.merge((Observable)metrics).map(event -> this.handleMetricEvent(event.getEventAsString())).doOnTerminate(this.observableOnTerminateCallback).doOnCompleted(this.observableOnCompleteCallback).doOnError(this.observableOnErrorCallback).subscribe();
    }

    protected Observable<Observable<MantisServerSentEvent>> getSourceJobMetrics() {
        List targetInfos = SourceJobParameters.parseTargetInfo((String)((String)this.context.getParameters().get("mantis.jobmaster.autoscale.sourcejob.target", (Object)"{}")));
        if (targetInfos.isEmpty()) {
            targetInfos = SourceJobParameters.parseInputParameters((Context)this.context);
        }
        targetInfos = SourceJobParameters.enforceClientIdConsistency((List)targetInfos, (String)this.jobId);
        String additionalDropMetricPatterns = (String)this.context.getParameters().get("mantis.jobmaster.autoscale.sourcejob.dropMetricPatterns", (Object)"");
        this.autoScaleMetricsConfig.addSourceJobDropMetrics(additionalDropMetricPatterns);
        SourceJobWorkerMetricsSubscription sourceSub = new SourceJobWorkerMetricsSubscription(targetInfos, this.masterClientApi, this.workerMetricsClient, this.autoScaleMetricsConfig);
        return sourceSub.getResults();
    }

    public void shutdown() {
        if (this.subscription != null) {
            this.subscription.unsubscribe();
        }
    }

    public void enterActiveMode() {
    }
}

