/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.worker.jobmaster;

import io.mantisrx.common.MantisProperties;
import io.mantisrx.control.IActuator;
import io.mantisrx.control.clutch.Clutch;
import io.mantisrx.control.clutch.ClutchExperimental;
import io.mantisrx.control.clutch.IRpsMetricComputer;
import io.mantisrx.control.clutch.IScaleComputer;
import io.mantisrx.runtime.Context;
import io.mantisrx.runtime.descriptor.SchedulingInfo;
import io.mantisrx.runtime.descriptor.StageScalingPolicy;
import io.mantisrx.runtime.descriptor.StageSchedulingInfo;
import io.mantisrx.server.core.stats.UsageDataStats;
import io.mantisrx.server.master.client.MantisMasterGateway;
import io.mantisrx.server.worker.jobmaster.JobAutoscalerManager;
import io.mantisrx.server.worker.jobmaster.clutch.ClutchAutoScaler;
import io.mantisrx.server.worker.jobmaster.clutch.ClutchConfiguration;
import io.mantisrx.server.worker.jobmaster.clutch.experimental.MantisClutchConfigurationSelector;
import io.mantisrx.server.worker.jobmaster.clutch.rps.ClutchRpsPIDConfig;
import io.mantisrx.server.worker.jobmaster.clutch.rps.RpsClutchConfigurationSelector;
import io.mantisrx.server.worker.jobmaster.clutch.rps.RpsMetricComputer;
import io.mantisrx.server.worker.jobmaster.clutch.rps.RpsScaleComputer;
import io.mantisrx.server.worker.jobmaster.control.actuators.MantisStageActuator;
import io.mantisrx.server.worker.jobmaster.control.utils.TransformerWrapper;
import io.mantisrx.shaded.com.fasterxml.jackson.core.type.TypeReference;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.Module;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.mantisrx.shaded.io.vavr.jackson.datatype.VavrModule;
import io.vavr.CheckedFunction0;
import io.vavr.Function1;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.BackpressureOverflow;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Func1;
import rx.observers.SerializedObserver;
import rx.subjects.PublishSubject;

public class JobAutoScaler {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(JobAutoScaler.class);
    private static final String PercentNumberFormat = "%5.2f";
    private static final Map<StageScalingPolicy.ScalingReason, Clutch.Metric> metricMap = new HashMap<StageScalingPolicy.ScalingReason, Clutch.Metric>();
    private final String jobId;
    private final MantisMasterGateway masterClientApi;
    private final SchedulingInfo schedulingInfo;
    private final PublishSubject<Event> subject;
    private final Context context;
    private final JobAutoscalerManager jobAutoscalerManager;

    JobAutoScaler(String jobId, SchedulingInfo schedulingInfo, MantisMasterGateway masterClientApi, Context context, JobAutoscalerManager jobAutoscalerManager) {
        this.jobId = jobId;
        this.masterClientApi = masterClientApi;
        this.schedulingInfo = schedulingInfo;
        this.subject = PublishSubject.create();
        this.context = context;
        this.jobAutoscalerManager = jobAutoscalerManager;
    }

    Observer<Event> getObserver() {
        return new SerializedObserver(this.subject);
    }

    private io.mantisrx.control.clutch.Event mantisEventToClutchEvent(Event event) {
        logger.debug("Converting Mantis event to Clutch event: {}", (Object)event);
        return new io.mantisrx.control.clutch.Event(metricMap.get(event.type), event.getEffectiveValue());
    }

    void start() {
        this.subject.onBackpressureBuffer(100L, () -> logger.info("onOverflow triggered, dropping old events"), BackpressureOverflow.ON_OVERFLOW_DROP_OLDEST).doOnRequest(x -> logger.info("Scaler requested {} metrics.", x)).groupBy(Event::getStage).flatMap(go -> {
            Integer stage = (Integer)Optional.ofNullable(go.getKey()).orElse(-1);
            StageSchedulingInfo stageSchedulingInfo = this.schedulingInfo.forStage(stage.intValue());
            logger.debug("System Environment:");
            System.getenv().forEach((key, value) -> logger.debug("{} = {}", key, value));
            Optional<String> clutchCustomConfiguration = Optional.ofNullable(MantisProperties.getProperty((String)"JOB_PARAM_mantis.jobmaster.clutch.config"));
            if (stageSchedulingInfo != null && (stageSchedulingInfo.getScalingPolicy() != null || clutchCustomConfiguration.isPresent())) {
                ClutchConfiguration config = null;
                int minSize = 0;
                int maxSize = 0;
                boolean useJsonConfigBased = false;
                boolean useClutch = false;
                boolean useClutchRps = false;
                boolean useClutchExperimental = false;
                StageScalingPolicy scalingPolicy = stageSchedulingInfo.getScalingPolicy();
                if (scalingPolicy != null) {
                    minSize = scalingPolicy.getMin();
                    maxSize = scalingPolicy.getMax();
                    if (scalingPolicy.getStrategies() != null) {
                        Set reasons = scalingPolicy.getStrategies().values().stream().map(StageScalingPolicy.Strategy::getReason).collect(Collectors.toSet());
                        if (reasons.contains(StageScalingPolicy.ScalingReason.Clutch)) {
                            useClutch = true;
                        } else if (reasons.contains(StageScalingPolicy.ScalingReason.ClutchExperimental)) {
                            useClutchExperimental = true;
                        } else if (reasons.contains(StageScalingPolicy.ScalingReason.ClutchRps)) {
                            useClutchRps = true;
                        }
                    }
                }
                if (clutchCustomConfiguration.isPresent()) {
                    try {
                        config = this.getClutchConfiguration(clutchCustomConfiguration.get()).get(stage);
                    }
                    catch (Exception ex) {
                        logger.error("Error parsing json clutch config: {}", (Object)clutchCustomConfiguration.get(), (Object)ex);
                    }
                    if (config != null) {
                        if (config.getRpsConfig().isDefined()) {
                            useClutchRps = true;
                        } else if (((Boolean)config.getUseExperimental().getOrElse((Object)false)).booleanValue()) {
                            useClutch = true;
                        } else {
                            useJsonConfigBased = true;
                        }
                        if (config.getMinSize() > 0) {
                            minSize = config.getMinSize();
                        }
                        if (config.getMaxSize() > 0) {
                            maxSize = config.getMaxSize();
                        }
                    }
                }
                int initialSize = stageSchedulingInfo.getNumberOfInstances();
                StageScaler scaler = new StageScaler(stage, stageSchedulingInfo);
                MantisStageActuator actuator = new MantisStageActuator(initialSize, scaler);
                Observable.Transformer transformToClutchEvent = obs -> obs.map(this::mantisEventToClutchEvent).filter(event -> event.metric != null);
                Observable workerCounts = this.context.getWorkerMapObservable().map(x -> x.getWorkersForStage(((Integer)go.getKey()).intValue()).size()).distinctUntilChanged().throttleLast(5L, TimeUnit.SECONDS);
                if (useClutchRps) {
                    logger.info("Using clutch rps scaler, job: {}, stage: {} ", (Object)this.jobId, (Object)stage);
                    ClutchRpsPIDConfig rpsConfig = (ClutchRpsPIDConfig)Option.of((Object)config).flatMap(ClutchConfiguration::getRpsConfig).getOrNull();
                    return go.compose(transformToClutchEvent).compose((Observable.Transformer)new ClutchExperimental((IActuator)actuator, Integer.valueOf(initialSize), Integer.valueOf(minSize), Integer.valueOf(maxSize), workerCounts, Observable.interval((long)1L, (TimeUnit)TimeUnit.HOURS), TimeUnit.MINUTES.toMillis(10L), (Function1)new RpsClutchConfigurationSelector(stage, stageSchedulingInfo, config), (IRpsMetricComputer)new RpsMetricComputer(), (IScaleComputer)new RpsScaleComputer(rpsConfig)));
                }
                if (useJsonConfigBased) {
                    logger.info("Using json config based scaler, job: {}, stage: {} ", (Object)this.jobId, (Object)stage);
                    return go.compose((Observable.Transformer)new ClutchAutoScaler(stageSchedulingInfo, scaler, config, initialSize));
                }
                if (useClutch) {
                    logger.info("Using clutch scaler, job: {}, stage: {} ", (Object)this.jobId, (Object)stage);
                    return go.compose(transformToClutchEvent).compose((Observable.Transformer)new Clutch((IActuator)actuator, Integer.valueOf(initialSize), Integer.valueOf(minSize), Integer.valueOf(maxSize)));
                }
                if (useClutchExperimental) {
                    logger.info("Using clutch experimental scaler, job: {}, stage: {} ", (Object)this.jobId, (Object)stage);
                    return go.compose(transformToClutchEvent).compose((Observable.Transformer)new ClutchExperimental((IActuator)actuator, Integer.valueOf(initialSize), Integer.valueOf(minSize), Integer.valueOf(maxSize), workerCounts, Observable.interval((long)1L, (TimeUnit)TimeUnit.HOURS), TimeUnit.MINUTES.toMillis(10L), (Function1)new MantisClutchConfigurationSelector(stage, stageSchedulingInfo)));
                }
                logger.info("Using rule based scaler, job: {}, stage: {} ", (Object)this.jobId, (Object)stage);
                return go.compose(new TransformerWrapper<Event, Object>(new StageScaleOperator(stage, stageSchedulingInfo)));
            }
            return go;
        }).doOnCompleted(() -> logger.info("onComplete on JobAutoScaler subject")).doOnError(t -> logger.error("got onError in JobAutoScaler", t)).doOnSubscribe(() -> logger.info("onSubscribe JobAutoScaler")).doOnUnsubscribe(() -> logger.info("Unsubscribing for JobAutoScaler of job {}", (Object)this.jobId)).retry().subscribe();
    }

    protected Map<Integer, ClutchConfiguration> getClutchConfiguration(String jsonConfig) {
        return (Map)Try.of((CheckedFunction0 & Serializable)() -> (Map)objectMapper.readValue(jsonConfig, (TypeReference)new TypeReference<Map<Integer, ClutchConfiguration>>(){})).getOrElseGet(t -> (Map)Try.of((CheckedFunction0 & Serializable)() -> {
            ClutchConfiguration config = (ClutchConfiguration)objectMapper.readValue(jsonConfig, (TypeReference)new TypeReference<ClutchConfiguration>(){});
            HashMap<Integer, ClutchConfiguration> configs = new HashMap<Integer, ClutchConfiguration>();
            configs.put(1, config);
            return configs;
        }).get());
    }

    static {
        objectMapper.registerModule((Module)new VavrModule());
        metricMap.put(StageScalingPolicy.ScalingReason.CPU, Clutch.Metric.CPU);
        metricMap.put(StageScalingPolicy.ScalingReason.JVMMemory, Clutch.Metric.MEMORY);
        metricMap.put(StageScalingPolicy.ScalingReason.Network, Clutch.Metric.NETWORK);
        metricMap.put(StageScalingPolicy.ScalingReason.KafkaLag, Clutch.Metric.LAG);
        metricMap.put(StageScalingPolicy.ScalingReason.DataDrop, Clutch.Metric.DROPS);
        metricMap.put(StageScalingPolicy.ScalingReason.UserDefined, Clutch.Metric.UserDefined);
        metricMap.put(StageScalingPolicy.ScalingReason.RPS, Clutch.Metric.RPS);
        metricMap.put(StageScalingPolicy.ScalingReason.SourceJobDrop, Clutch.Metric.SOURCEJOB_DROP);
    }

    private class StageScaleOperator<T, R>
    implements Observable.Operator<Object, Event> {
        private final int stage;
        private final StageSchedulingInfo stageSchedulingInfo;
        private final StageScaler scaler;
        private volatile long lastScaledAt = 0L;

        private StageScaleOperator(int stage, StageSchedulingInfo stageSchedulingInfo) {
            this.stage = stage;
            this.stageSchedulingInfo = stageSchedulingInfo;
            this.scaler = new StageScaler(stage, this.stageSchedulingInfo);
            logger.info("cooldownSecs set to {}", (Object)stageSchedulingInfo.getScalingPolicy().getCoolDownSecs());
        }

        public Subscriber<? super Event> call(final Subscriber<? super Object> child) {
            return new Subscriber<Event>(){
                private final Map<StageScalingPolicy.ScalingReason, UsageDataStats> dataStatsMap = new HashMap<StageScalingPolicy.ScalingReason, UsageDataStats>();

                public void onCompleted() {
                    child.unsubscribe();
                }

                public void onError(Throwable e) {
                    logger.error("Unexpected error: " + e.getMessage(), e);
                }

                public void onNext(Event event) {
                    StageScalingPolicy.Strategy strategy;
                    StageScalingPolicy scalingPolicy = StageScaleOperator.this.stageSchedulingInfo.getScalingPolicy();
                    long coolDownSecs = scalingPolicy == null ? Long.MAX_VALUE : scalingPolicy.getCoolDownSecs();
                    boolean scalable = StageScaleOperator.this.stageSchedulingInfo.getScalable() && scalingPolicy != null && scalingPolicy.isEnabled();
                    logger.debug("Will check for autoscaling job {} stage {} due to event: {}", new Object[]{JobAutoScaler.this.jobId, StageScaleOperator.this.stage, event});
                    if (scalable && (strategy = (StageScalingPolicy.Strategy)scalingPolicy.getStrategies().get(event.getType())) != null) {
                        double effectiveValue = event.getEffectiveValue();
                        UsageDataStats stats = this.dataStatsMap.get(event.getType());
                        if (stats == null) {
                            stats = new UsageDataStats(strategy.getScaleUpAbovePct(), strategy.getScaleDownBelowPct(), strategy.getRollingCount());
                            this.dataStatsMap.put(event.getType(), stats);
                        }
                        stats.add(effectiveValue);
                        if (StageScaleOperator.this.lastScaledAt < System.currentTimeMillis() - coolDownSecs * 1000L) {
                            logger.info("{}, stage {}, eventType {}: eff={}, thresh={}", new Object[]{JobAutoScaler.this.jobId, StageScaleOperator.this.stage, event.getType(), String.format(JobAutoScaler.PercentNumberFormat, effectiveValue), strategy.getScaleUpAbovePct()});
                            if (stats.getHighThreshTriggered()) {
                                logger.info("Attempting to scale up stage {} of job {} by {} workers, because {} exceeded scaleUpThreshold of {} {} times", new Object[]{StageScaleOperator.this.stage, JobAutoScaler.this.jobId, scalingPolicy.getIncrement(), event.getType(), String.format(JobAutoScaler.PercentNumberFormat, strategy.getScaleUpAbovePct()), stats.getCurrentHighCount()});
                                int numCurrWorkers = event.getNumWorkers();
                                int desiredWorkers = StageScaleOperator.this.scaler.getDesiredWorkersForScaleUp(scalingPolicy.getIncrement(), numCurrWorkers, event);
                                if (desiredWorkers > numCurrWorkers) {
                                    StageScaleOperator.this.scaler.scaleUpStage(numCurrWorkers, desiredWorkers, event.getType() + " with value " + String.format(JobAutoScaler.PercentNumberFormat, effectiveValue) + " exceeded scaleUp threshold of " + strategy.getScaleUpAbovePct());
                                    StageScaleOperator.this.lastScaledAt = System.currentTimeMillis();
                                    logger.info("lastScaledAt set to {} after scale up request", (Object)StageScaleOperator.this.lastScaledAt);
                                } else {
                                    logger.debug("scale up NOOP: desiredWorkers same as current workers");
                                }
                            } else if (stats.getLowThreshTriggered()) {
                                logger.info("Attempting to scale down stage {} of job {} by {} workers, because {} is below scaleDownThreshold of {} {} times", new Object[]{StageScaleOperator.this.stage, JobAutoScaler.this.jobId, scalingPolicy.getDecrement(), event.getType(), strategy.getScaleDownBelowPct(), stats.getCurrentLowCount()});
                                int numCurrentWorkers = event.getNumWorkers();
                                int desiredWorkers = StageScaleOperator.this.scaler.getDesiredWorkersForScaleDown(scalingPolicy.getDecrement(), numCurrentWorkers, event);
                                if (desiredWorkers < numCurrentWorkers) {
                                    StageScaleOperator.this.scaler.scaleDownStage(numCurrentWorkers, desiredWorkers, event.getType() + " with value " + String.format(JobAutoScaler.PercentNumberFormat, effectiveValue) + " is below scaleDown threshold of " + strategy.getScaleDownBelowPct());
                                    StageScaleOperator.this.lastScaledAt = System.currentTimeMillis();
                                    logger.info("lastScaledAt set to {} after scale down request", (Object)StageScaleOperator.this.lastScaledAt);
                                } else {
                                    logger.debug("scale down NOOP: desiredWorkers same as current workers");
                                }
                            }
                        } else {
                            logger.debug("lastScaledAt {} within cooldown period", (Object)StageScaleOperator.this.lastScaledAt);
                        }
                    }
                }
            };
        }
    }

    public class StageScaler {
        private final int stage;
        private final StageSchedulingInfo stageSchedulingInfo;
        private final AtomicReference<Subscription> inProgressScalingSubscription = new AtomicReference<Object>(null);
        private final Func1<Observable<? extends Throwable>, Observable<?>> retryLogic = attempts -> attempts.zipWith(Observable.range((int)1, (int)Integer.MAX_VALUE), (t1, integer) -> integer).flatMap(integer -> {
            long delay = 2 * (integer > 5 ? 10 : integer);
            logger.info("retrying scaleJobStage request after sleeping for " + delay + " secs");
            return Observable.timer((long)delay, (TimeUnit)TimeUnit.SECONDS);
        });

        public StageScaler(int stage, StageSchedulingInfo stageSchedulingInfo) {
            this.stage = stage;
            this.stageSchedulingInfo = stageSchedulingInfo;
        }

        private void cancelOutstandingScalingRequest() {
            if (this.inProgressScalingSubscription.get() != null && !this.inProgressScalingSubscription.get().isUnsubscribed()) {
                this.inProgressScalingSubscription.get().unsubscribe();
                this.inProgressScalingSubscription.set(null);
            }
        }

        private void setOutstandingScalingRequest(Subscription subscription) {
            this.inProgressScalingSubscription.compareAndSet(null, subscription);
        }

        private int getDesiredWorkers(StageScalingPolicy scalingPolicy, Event event) {
            int maxWorkersForStage = scalingPolicy.getMax();
            int minWorkersForStage = scalingPolicy.getMin();
            return minWorkersForStage + (int)Math.round((double)(maxWorkersForStage - minWorkersForStage) * event.getEffectiveValue() / 100.0);
        }

        public int getDesiredWorkersForScaleUp(int increment, int numCurrentWorkers, Event event) {
            int desiredWorkers;
            StageScalingPolicy scalingPolicy = this.stageSchedulingInfo.getScalingPolicy();
            if (!scalingPolicy.isEnabled()) {
                logger.warn("Job {} stage {} is not scalable, can't increment #workers by {}", new Object[]{JobAutoScaler.this.jobId, this.stage, increment});
                return numCurrentWorkers;
            }
            if (numCurrentWorkers < 0 || increment < 1) {
                logger.error("current number of workers({}) not known or increment({}) < 1, will not scale up", (Object)numCurrentWorkers, (Object)increment);
                return numCurrentWorkers;
            }
            if (scalingPolicy.isAllowAutoScaleManager() && !JobAutoScaler.this.jobAutoscalerManager.isScaleUpEnabled()) {
                logger.warn("Scaleup is disabled for all autoscaling strategy, not scaling up stage {} of job {}", (Object)this.stage, (Object)JobAutoScaler.this.jobId);
                return numCurrentWorkers;
            }
            if (event.getType() == StageScalingPolicy.ScalingReason.AutoscalerManagerEvent) {
                desiredWorkers = this.getDesiredWorkers(scalingPolicy, event);
                logger.info("AutoscalerManagerEvent scaling up stage {} of job {} to desiredWorkers {}", new Object[]{this.stage, JobAutoScaler.this.jobId, desiredWorkers});
            } else {
                int maxWorkersForStage = scalingPolicy.getMax();
                desiredWorkers = Math.min(numCurrentWorkers + increment, maxWorkersForStage);
            }
            return desiredWorkers;
        }

        public void scaleUpStage(int numCurrentWorkers, int desiredWorkers, String reason) {
            logger.info("scaleUpStage incrementing number of workers from {} to {}", (Object)numCurrentWorkers, (Object)desiredWorkers);
            this.cancelOutstandingScalingRequest();
            StageScalingPolicy scalingPolicy = this.stageSchedulingInfo.getScalingPolicy();
            if (scalingPolicy != null && scalingPolicy.isAllowAutoScaleManager() && !JobAutoScaler.this.jobAutoscalerManager.isScaleUpEnabled()) {
                logger.warn("Scaleup is disabled for all autoscaling strategy, not scaling up stage {} of job {}", (Object)this.stage, (Object)JobAutoScaler.this.jobId);
                return;
            }
            Subscription subscription = JobAutoScaler.this.masterClientApi.scaleJobStage(JobAutoScaler.this.jobId, this.stage, desiredWorkers, reason).retryWhen(this.retryLogic).onErrorResumeNext(throwable -> {
                logger.error("caught error when scaling up stage {}", (Object)this.stage);
                return Observable.empty();
            }).subscribe();
            this.setOutstandingScalingRequest(subscription);
        }

        public int getDesiredWorkersForScaleDown(int decrement, int numCurrentWorkers, Event event) {
            int desiredWorkers;
            StageScalingPolicy scalingPolicy = this.stageSchedulingInfo.getScalingPolicy();
            if (!scalingPolicy.isEnabled()) {
                logger.warn("Job {} stage {} is not scalable, can't decrement #workers by {}", new Object[]{JobAutoScaler.this.jobId, this.stage, decrement});
                return numCurrentWorkers;
            }
            if (numCurrentWorkers < 0 || decrement < 1) {
                logger.error("current number of workers({}) not known or decrement({}) < 1, will not scale down", (Object)numCurrentWorkers, (Object)decrement);
                return numCurrentWorkers;
            }
            if (scalingPolicy.isAllowAutoScaleManager() && !JobAutoScaler.this.jobAutoscalerManager.isScaleDownEnabled()) {
                logger.warn("Scaledown is disabled for all autoscaling strategy, not scaling down stage {} of job {}", (Object)this.stage, (Object)JobAutoScaler.this.jobId);
                return numCurrentWorkers;
            }
            if (event.getType() == StageScalingPolicy.ScalingReason.AutoscalerManagerEvent) {
                desiredWorkers = this.getDesiredWorkers(scalingPolicy, event);
                logger.info("AutoscalerManagerEvent scaling up stage {} of job {} to desiredWorkers {}", new Object[]{this.stage, JobAutoScaler.this.jobId, desiredWorkers});
            } else {
                int min = scalingPolicy.getMin();
                desiredWorkers = Math.max(numCurrentWorkers - decrement, min);
            }
            return desiredWorkers;
        }

        public void scaleDownStage(int numCurrentWorkers, int desiredWorkers, String reason) {
            logger.info("scaleDownStage decrementing number of workers from {} to {}", (Object)numCurrentWorkers, (Object)desiredWorkers);
            this.cancelOutstandingScalingRequest();
            StageScalingPolicy scalingPolicy = this.stageSchedulingInfo.getScalingPolicy();
            if (scalingPolicy != null && scalingPolicy.isAllowAutoScaleManager() && !JobAutoScaler.this.jobAutoscalerManager.isScaleDownEnabled()) {
                logger.warn("Scaledown is disabled for all autoscaling strategy. For stage {} of job {}", (Object)this.stage, (Object)JobAutoScaler.this.jobId);
                return;
            }
            Subscription subscription = JobAutoScaler.this.masterClientApi.scaleJobStage(JobAutoScaler.this.jobId, this.stage, desiredWorkers, reason).retryWhen(this.retryLogic).onErrorResumeNext(throwable -> {
                logger.error("caught error when scaling down stage {}", (Object)this.stage);
                return Observable.empty();
            }).subscribe();
            this.setOutstandingScalingRequest(subscription);
        }

        public int getStage() {
            return this.stage;
        }
    }

    public static final class Event {
        private final StageScalingPolicy.ScalingReason type;
        private final int stage;
        private final double value;
        private final double effectiveValue;
        private final int numWorkers;
        private final String message;

        public Event(StageScalingPolicy.ScalingReason type, int stage, double value, double effectiveValue, int numWorkers) {
            this.type = type;
            this.stage = stage;
            this.value = value;
            this.effectiveValue = effectiveValue;
            this.numWorkers = numWorkers;
            this.message = "";
        }

        public StageScalingPolicy.ScalingReason getType() {
            return this.type;
        }

        public int getStage() {
            return this.stage;
        }

        public double getValue() {
            return this.value;
        }

        public double getEffectiveValue() {
            return this.effectiveValue;
        }

        public int getNumWorkers() {
            return this.numWorkers;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Event)) {
                return false;
            }
            Event other = (Event)o;
            if (this.getStage() != other.getStage()) {
                return false;
            }
            if (Double.compare(this.getValue(), other.getValue()) != 0) {
                return false;
            }
            if (Double.compare(this.getEffectiveValue(), other.getEffectiveValue()) != 0) {
                return false;
            }
            if (this.getNumWorkers() != other.getNumWorkers()) {
                return false;
            }
            StageScalingPolicy.ScalingReason this$type = this.getType();
            StageScalingPolicy.ScalingReason other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getStage();
            long $value = Double.doubleToLongBits(this.getValue());
            result = result * 59 + (int)($value >>> 32 ^ $value);
            long $effectiveValue = Double.doubleToLongBits(this.getEffectiveValue());
            result = result * 59 + (int)($effectiveValue >>> 32 ^ $effectiveValue);
            result = result * 59 + this.getNumWorkers();
            StageScalingPolicy.ScalingReason $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        public String toString() {
            return "JobAutoScaler.Event(type=" + this.getType() + ", stage=" + this.getStage() + ", value=" + this.getValue() + ", effectiveValue=" + this.getEffectiveValue() + ", numWorkers=" + this.getNumWorkers() + ", message=" + this.getMessage() + ")";
        }

        @ConstructorProperties(value={"type", "stage", "value", "effectiveValue", "numWorkers", "message"})
        public Event(StageScalingPolicy.ScalingReason type, int stage, double value, double effectiveValue, int numWorkers, String message) {
            this.type = type;
            this.stage = stage;
            this.value = value;
            this.effectiveValue = effectiveValue;
            this.numWorkers = numWorkers;
            this.message = message;
        }
    }
}

