/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.worker.jobmaster.control.utils;

import io.mantisrx.server.worker.jobmaster.control.Controller;

public class ErrorComputer
extends Controller {
    private final double setPoint;
    private final boolean inverted;
    private final double lowerRope;
    private final double upperRope;

    public ErrorComputer(double setPoint, boolean inverted, double lowerRope, double upperRope) {
        this.setPoint = setPoint;
        this.inverted = inverted;
        this.lowerRope = lowerRope;
        this.upperRope = upperRope;
    }

    public ErrorComputer(double setPoint, boolean inverted, double rope) {
        this.setPoint = setPoint;
        this.inverted = inverted;
        this.lowerRope = rope;
        this.upperRope = rope;
    }

    public static double loss(double setPoint, double observed, double lowerRope, double upperRope) {
        if (observed > setPoint + upperRope) {
            return setPoint + upperRope - observed;
        }
        if (observed < setPoint - lowerRope) {
            return setPoint - lowerRope - observed;
        }
        return 0.0;
    }

    @Override
    public Double processStep(Double input) {
        return this.inverted ? -1.0 * ErrorComputer.loss(this.setPoint, input, this.lowerRope, this.upperRope) : ErrorComputer.loss(this.setPoint, input, this.lowerRope, this.upperRope);
    }
}

