/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.worker.jobmaster;

import io.mantisrx.common.MantisServerSentEvent;
import io.mantisrx.runtime.parameter.SinkParameters;
import io.mantisrx.server.worker.client.MetricsClient;
import io.mantisrx.server.worker.client.SseWorkerConnectionFunction;
import io.mantisrx.server.worker.client.WorkerConnectionFunc;
import io.mantisrx.server.worker.client.WorkerConnectionsStatus;
import io.mantisrx.server.worker.client.WorkerMetricsClient;
import java.io.UnsupportedEncodingException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observer;
import rx.functions.Action1;

public class WorkerMetricSubscription {
    private static final Logger logger = LoggerFactory.getLogger(WorkerMetricSubscription.class);
    final MetricsClient<MantisServerSentEvent> metricsClient;
    private final Set<String> metrics;

    public WorkerMetricSubscription(String jobId, WorkerMetricsClient workerMetricsClient, Set<String> metricGroups) {
        this.metrics = metricGroups;
        SinkParameters metricNamesFilter = null;
        try {
            SinkParameters.Builder sinkParamsBuilder = new SinkParameters.Builder();
            for (String metric : metricGroups) {
                sinkParamsBuilder = sinkParamsBuilder.withParameter("name", metric);
            }
            metricNamesFilter = sinkParamsBuilder.build();
        }
        catch (UnsupportedEncodingException e) {
            logger.error("error encoding sink parameters", (Throwable)e);
        }
        this.metricsClient = workerMetricsClient.getMetricsClientByJobId(jobId, (WorkerConnectionFunc)new SseWorkerConnectionFunction(true, (Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                logger.error("Metric connection error: " + throwable.getMessage());
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    logger.error("Interrupted waiting for retrying connection");
                }
            }
        }, metricNamesFilter), (Observer)new Observer<WorkerConnectionsStatus>(){

            public void onCompleted() {
                logger.info("got onCompleted in WorkerConnStatus obs");
            }

            public void onError(Throwable e) {
                logger.info("got onError in WorkerConnStatus obs");
            }

            public void onNext(WorkerConnectionsStatus workerConnectionsStatus) {
                logger.info("got WorkerConnStatus {}", (Object)workerConnectionsStatus);
            }
        });
    }

    public Set<String> getMetrics() {
        return this.metrics;
    }

    public MetricsClient<MantisServerSentEvent> getMetricsClient() {
        return this.metricsClient;
    }
}

