/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.worker.jobmaster;

import io.mantisrx.server.worker.jobmaster.AutoScaleMetricsConfig;
import io.mantisrx.server.worker.jobmaster.GaugeData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MetricAggregator {
    private static final Logger logger = LoggerFactory.getLogger(MetricAggregator.class);
    private final AutoScaleMetricsConfig autoScaleMetricsConfig;

    MetricAggregator(AutoScaleMetricsConfig autoScaleMetricsConfig) {
        this.autoScaleMetricsConfig = autoScaleMetricsConfig;
    }

    public Map<String, GaugeData> getAggregates(Map<String, List<GaugeData>> dataPointsByMetricGrp) {
        HashMap<String, GaugeData> result = new HashMap<String, GaugeData>();
        for (Map.Entry<String, List<GaugeData>> metricGrpGauges : dataPointsByMetricGrp.entrySet()) {
            String metricGrp = metricGrpGauges.getKey();
            List<GaugeData> gaugeDataList = metricGrpGauges.getValue();
            int n = 0;
            HashMap<String, Double> gaugeAggregates = new HashMap<String, Double>();
            for (GaugeData gaugeData : gaugeDataList) {
                ++n;
                Map<String, Double> gauges = gaugeData.getGauges();
                block6: for (Map.Entry<String, Double> gaugeEntry : gauges.entrySet()) {
                    String gaugeName = gaugeEntry.getKey();
                    double currValue = gaugeEntry.getValue();
                    AutoScaleMetricsConfig.AggregationAlgo aggregationAlgo = this.autoScaleMetricsConfig.getAggregationAlgo(metricGrp, gaugeName);
                    switch (aggregationAlgo) {
                        case AVERAGE: {
                            if (!gaugeAggregates.containsKey(gaugeName)) {
                                gaugeAggregates.put(gaugeName, currValue);
                                continue block6;
                            }
                            double avg = ((Double)gaugeAggregates.get(gaugeName) * (double)(n - 1) + currValue) / (double)n;
                            gaugeAggregates.put(gaugeName, avg);
                            continue block6;
                        }
                        case MAX: {
                            if (!gaugeAggregates.containsKey(gaugeName)) {
                                gaugeAggregates.put(gaugeName, currValue);
                                continue block6;
                            }
                            Double prev = (Double)gaugeAggregates.get(gaugeName);
                            double max = currValue > prev ? currValue : prev;
                            gaugeAggregates.put(gaugeName, max);
                            continue block6;
                        }
                    }
                    logger.warn("unsupported aggregation algo {} for {}:{}", new Object[]{aggregationAlgo.name(), metricGrp, gaugeName});
                }
            }
            result.put(metricGrp, new GaugeData(System.currentTimeMillis(), gaugeAggregates));
        }
        return result;
    }
}

