/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.worker.jobmaster;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class AutoScaleMetricsConfig {
    public static final String CLIENT_ID_TOKEN = "_CLIENT_ID_";
    public static final String OUTBOUND_METRIC_GROUP_PATTERN = String.format("%s:%s=%s:*", "PushServerSse", "clientId", "_CLIENT_ID_");
    public static final String OUTBOUND_LEGACY_METRIC_GROUP_PATTERN = String.format("%s:%s=%s:*", "ServerSentEventRequestHandler", "clientId", "_CLIENT_ID_");
    private static final AggregationAlgo DEFAULT_ALGO = AggregationAlgo.AVERAGE;
    private static final Map<String, Map<String, AggregationAlgo>> defaultAutoScaleMetrics = new HashMap<String, Map<String, AggregationAlgo>>();
    private final Map<String, Map<String, AggregationAlgo>> sourceJobMetrics = new HashMap<String, Map<String, AggregationAlgo>>();
    private final Map<String, Pattern> sourceJobMetricsPatterns = new HashMap<String, Pattern>();
    private final Map<String, Map<String, AggregationAlgo>> userDefinedAutoScaleMetrics;

    public AutoScaleMetricsConfig() {
        this(new HashMap<String, Map<String, AggregationAlgo>>());
    }

    public AutoScaleMetricsConfig(Map<String, Map<String, AggregationAlgo>> userDefinedAutoScaleMetrics) {
        this.userDefinedAutoScaleMetrics = userDefinedAutoScaleMetrics;
        HashMap<String, AggregationAlgo> defaultOutboundMetric = new HashMap<String, AggregationAlgo>();
        defaultOutboundMetric.put("droppedCounter", AggregationAlgo.MAX);
        this.sourceJobMetrics.put(OUTBOUND_METRIC_GROUP_PATTERN, defaultOutboundMetric);
        this.sourceJobMetrics.put(OUTBOUND_LEGACY_METRIC_GROUP_PATTERN, defaultOutboundMetric);
        this.sourceJobMetricsPatterns.put(OUTBOUND_METRIC_GROUP_PATTERN, AutoScaleMetricsConfig.generateSourceJobMetricPattern(OUTBOUND_METRIC_GROUP_PATTERN));
        this.sourceJobMetricsPatterns.put(OUTBOUND_LEGACY_METRIC_GROUP_PATTERN, AutoScaleMetricsConfig.generateSourceJobMetricPattern(OUTBOUND_LEGACY_METRIC_GROUP_PATTERN));
    }

    public void addUserDefinedMetric(String metricGroupName, String metricName, AggregationAlgo algo) {
        this.userDefinedAutoScaleMetrics.putIfAbsent(metricGroupName, new HashMap());
        this.userDefinedAutoScaleMetrics.get(metricGroupName).put(metricName, algo);
    }

    public void addSourceJobDropMetrics(String metricsStr) {
        if (metricsStr == null) {
            return;
        }
        for (String metric : metricsStr.split(",")) {
            if ((metric = metric.trim()).isEmpty()) continue;
            try {
                String[] parts = metric.split("::");
                String metricGroupName = parts[0];
                String metricName = parts[1];
                AggregationAlgo algo = AggregationAlgo.valueOf(parts[2]);
                Map<String, AggregationAlgo> metricGroup = this.sourceJobMetrics.get(metricGroupName);
                if (metricGroup == null) {
                    metricGroup = new HashMap<String, AggregationAlgo>();
                    this.sourceJobMetrics.put(metricGroupName, metricGroup);
                    this.sourceJobMetricsPatterns.put(metricGroupName, AutoScaleMetricsConfig.generateSourceJobMetricPattern(metricGroupName));
                }
                metricGroup.put(metricName, algo);
            }
            catch (Exception ex) {
                String errMsg = String.format("Invalid format for source job metric: %s", metricsStr);
                throw new RuntimeException(errMsg, ex);
            }
        }
    }

    public AggregationAlgo getAggregationAlgo(String metricGroupName, String metricName) {
        if (this.userDefinedAutoScaleMetrics.containsKey(metricGroupName) && this.userDefinedAutoScaleMetrics.get(metricGroupName).containsKey(metricName)) {
            return this.userDefinedAutoScaleMetrics.get(metricGroupName).getOrDefault(metricName, DEFAULT_ALGO);
        }
        if (defaultAutoScaleMetrics.containsKey(metricGroupName) && defaultAutoScaleMetrics.get(metricGroupName).containsKey(metricName)) {
            return defaultAutoScaleMetrics.get(metricGroupName).getOrDefault(metricName, DEFAULT_ALGO);
        }
        for (Map.Entry<String, Pattern> entry : this.sourceJobMetricsPatterns.entrySet()) {
            if (!entry.getValue().matcher(metricGroupName).matches()) continue;
            return this.sourceJobMetrics.get(entry.getKey()).getOrDefault(metricName, DEFAULT_ALGO);
        }
        return DEFAULT_ALGO;
    }

    public Map<String, Set<String>> getAllMetrics() {
        HashMap<String, Set<String>> metrics = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Map<String, AggregationAlgo>> entry : defaultAutoScaleMetrics.entrySet()) {
            metrics.put(entry.getKey(), entry.getValue().keySet());
        }
        for (Map.Entry<String, Map<String, AggregationAlgo>> entry : this.userDefinedAutoScaleMetrics.entrySet()) {
            metrics.put(entry.getKey(), entry.getValue().keySet());
        }
        return metrics;
    }

    public Map<String, Set<String>> getUserDefinedMetrics() {
        HashMap<String, Set<String>> metrics = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Map<String, AggregationAlgo>> entry : this.userDefinedAutoScaleMetrics.entrySet()) {
            metrics.put(entry.getKey(), entry.getValue().keySet());
        }
        return metrics;
    }

    public Set<String> getMetricGroups() {
        return this.getAllMetrics().keySet();
    }

    public Set<String> generateSourceJobMetricGroups(Set<String> clientIds) {
        HashSet<String> results = new HashSet<String>();
        for (String clientId : clientIds) {
            for (String metricPattern : this.sourceJobMetrics.keySet()) {
                results.add(metricPattern.replaceAll(CLIENT_ID_TOKEN, clientId));
            }
        }
        return results;
    }

    public boolean isSourceJobDropMetric(String metricGroupName, String metricName) {
        for (Map.Entry<String, Pattern> entry : this.sourceJobMetricsPatterns.entrySet()) {
            if (!entry.getValue().matcher(metricGroupName).matches()) continue;
            return this.sourceJobMetrics.get(entry.getKey()).keySet().contains(metricName);
        }
        return false;
    }

    private static Pattern generateSourceJobMetricPattern(String metricGroupName) {
        return Pattern.compile(metricGroupName.replace("*", ".*").replaceAll(CLIENT_ID_TOKEN, ".*"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoScaleMetricsConfig that = (AutoScaleMetricsConfig)o;
        return this.userDefinedAutoScaleMetrics != null ? this.userDefinedAutoScaleMetrics.equals(that.userDefinedAutoScaleMetrics) : that.userDefinedAutoScaleMetrics == null;
    }

    public int hashCode() {
        return this.userDefinedAutoScaleMetrics != null ? this.userDefinedAutoScaleMetrics.hashCode() : 0;
    }

    public String toString() {
        return "AutoScaleMetricsConfig{userDefinedAutoScaleMetrics=" + this.userDefinedAutoScaleMetrics + '}';
    }

    static {
        defaultAutoScaleMetrics.put("ResourceUsage", new HashMap());
        defaultAutoScaleMetrics.put("DataDrop", new HashMap());
        HashMap<String, AggregationAlgo> defaultKafkaConsumerMetric = new HashMap<String, AggregationAlgo>();
        defaultKafkaConsumerMetric.put("records-lag-max", AggregationAlgo.MAX);
        defaultAutoScaleMetrics.put("consumer-fetch-manager-metrics", defaultKafkaConsumerMetric);
        HashMap<String, AggregationAlgo> defaultWorkerStageInnerInputMetric = new HashMap<String, AggregationAlgo>();
        defaultWorkerStageInnerInputMetric.put("onNextGauge", AggregationAlgo.AVERAGE);
        defaultAutoScaleMetrics.put("worker_stage_inner_input", defaultWorkerStageInnerInputMetric);
    }

    public static enum AggregationAlgo {
        AVERAGE,
        MAX;

    }
}

