/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.worker.jobmaster.control.actuators;

import io.mantisrx.server.worker.jobmaster.JobAutoScaler;
import io.mantisrx.server.worker.jobmaster.control.actuators.MantisStageActuator;
import io.vavr.Tuple3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class ClutchMantisStageActuator
implements Observable.Transformer<Tuple3<String, Double, Integer>, Double> {
    private static Logger logger = LoggerFactory.getLogger(MantisStageActuator.class);
    private final JobAutoScaler.StageScaler scaler;

    public ClutchMantisStageActuator(JobAutoScaler.StageScaler scaler) {
        this.scaler = scaler;
    }

    protected Double processStep(Tuple3<String, Double, Integer> tup) {
        int desiredNumWorkers = Double.valueOf(Math.ceil((Double)tup._2)).intValue();
        logger.info("Received request to scale to {} from {} workers.", (Object)desiredNumWorkers, tup._3);
        String reason = (String)tup._1;
        if (desiredNumWorkers < (Integer)tup._3) {
            this.scaler.scaleDownStage((Integer)tup._3, desiredNumWorkers, reason);
        } else if (desiredNumWorkers > (Integer)tup._3) {
            this.scaler.scaleUpStage((Integer)tup._3, desiredNumWorkers, reason);
        }
        return (double)desiredNumWorkers * 1.0;
    }

    public Observable<Double> call(Observable<Tuple3<String, Double, Integer>> tuple2Observable) {
        return tuple2Observable.map(this::processStep);
    }
}

