/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.worker;

import io.mantisrx.common.metrics.Gauge;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import io.mantisrx.common.storage.StorageUnit;
import io.mantisrx.runtime.loader.config.MetricsCollector;
import io.mantisrx.runtime.loader.config.Usage;
import io.mantisrx.runtime.loader.config.WorkerConfiguration;
import io.mantisrx.server.core.StatusPayloads;
import io.mantisrx.server.worker.Heartbeat;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUsagePayloadSetter
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(ResourceUsagePayloadSetter.class);
    private static final long bigUsageChgReportingIntervalSecs = 10L;
    private static final double bigIncreaseThreshold = 0.05;
    private final Heartbeat heartbeat;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final ScheduledThreadPoolExecutor executor;
    private final long[] reportingIntervals;
    private final AtomicInteger counter = new AtomicInteger();
    private final MetricsCollector resourceUsageUtils;
    private final Gauge cpuLimitGauge;
    private final Gauge cpuUsageCurrGauge;
    private final Gauge cpuUsagePeakGauge;
    private final Gauge memLimitGauge;
    private final Gauge cachedMemUsageCurrGauge;
    private final Gauge cachedMemUsagePeakGauge;
    private final Gauge totMemUsageCurrGauge;
    private final Gauge totMemUsagePeakGauge;
    private final Gauge nwBytesLimitGauge;
    private final Gauge nwBytesUsageCurrGauge;
    private final Gauge nwBytesUsagePeakGauge;
    private final Gauge jvmMemoryUsedGauge;
    private final Gauge jvmMemoryMaxGauge;
    private final double nwBytesLimit;
    private double prev_cpus_system_time_secs = -1.0;
    private double prev_cpus_user_time_secs = -1.0;
    private double prev_bytes_read = -1.0;
    private double prev_bytes_written = -1.0;
    private long prevStatsGatheredAt = 0L;
    private double peakCpuUsage = 0.0;
    private double peakMemCache = 0.0;
    private double peakTotMem = 0.0;
    private double peakBytesRead = 0.0;
    private double peakBytesWritten = 0.0;
    private StatusPayloads.ResourceUsage oldUsage = null;

    public ResourceUsagePayloadSetter(Heartbeat heartbeat, WorkerConfiguration config, double networkMbps) {
        this.heartbeat = heartbeat;
        this.nwBytesLimit = networkMbps * 1024.0 * 1024.0 / 8.0;
        this.executor = new ScheduledThreadPoolExecutor(1);
        String defaultReportingSchedule = "5,5,10,10,20,30";
        StringTokenizer tokenizer = new StringTokenizer(defaultReportingSchedule, ",");
        this.reportingIntervals = new long[tokenizer.countTokens()];
        int t = 0;
        while (tokenizer.hasMoreTokens()) {
            this.reportingIntervals[t++] = Long.parseLong(tokenizer.nextToken());
        }
        this.resourceUsageUtils = config.getUsageSupplier();
        String cpuLimitGaugeName = "cpuPctLimit";
        String cpuUsageCurrGaugeName = "cpuPctUsageCurr";
        String cpuUsagePeakGaugeName = "cpuPctUsagePeak";
        String memLimitGaugeName = "memLimit";
        String cachedMemUsageCurrGaugeName = "cachedMemUsageCurr";
        String cachedMemUsagePeakGaugeName = "cachedMemUsagePeak";
        String totMemUsageCurrGaugeName = "totMemUsageCurr";
        String totMemUsagePeakGaugeName = "totMemUsagePeak";
        String nwBytesLimitGaugeName = "nwBytesLimit";
        String nwBytesUsageCurrGaugeName = "nwBytesUsageCurr";
        String nwBytesUsagePeakGaugeName = "nwBytesUsagePeak";
        String jvmMemoryUsedGaugeName = "jvmMemoryUsedBytes";
        String jvmMemoryMaxGaugeName = "jvmMemoryMaxBytes";
        Metrics m = new Metrics.Builder().name("ResourceUsage").addGauge(cpuLimitGaugeName).addGauge(cpuUsageCurrGaugeName).addGauge(cpuUsagePeakGaugeName).addGauge(memLimitGaugeName).addGauge(cachedMemUsageCurrGaugeName).addGauge(cachedMemUsagePeakGaugeName).addGauge(totMemUsageCurrGaugeName).addGauge(totMemUsagePeakGaugeName).addGauge(nwBytesLimitGaugeName).addGauge(nwBytesUsageCurrGaugeName).addGauge(nwBytesUsagePeakGaugeName).addGauge(jvmMemoryUsedGaugeName).addGauge(jvmMemoryMaxGaugeName).build();
        m = MetricsRegistry.getInstance().registerAndGet(m);
        this.cpuLimitGauge = m.getGauge(cpuLimitGaugeName);
        this.cpuUsageCurrGauge = m.getGauge(cpuUsageCurrGaugeName);
        this.cpuUsagePeakGauge = m.getGauge(cpuUsagePeakGaugeName);
        this.memLimitGauge = m.getGauge(memLimitGaugeName);
        this.cachedMemUsageCurrGauge = m.getGauge(cachedMemUsageCurrGaugeName);
        this.cachedMemUsagePeakGauge = m.getGauge(cachedMemUsagePeakGaugeName);
        this.totMemUsageCurrGauge = m.getGauge(totMemUsageCurrGaugeName);
        this.totMemUsagePeakGauge = m.getGauge(totMemUsagePeakGaugeName);
        this.nwBytesLimitGauge = m.getGauge(nwBytesLimitGaugeName);
        this.nwBytesUsageCurrGauge = m.getGauge(nwBytesUsageCurrGaugeName);
        this.nwBytesUsagePeakGauge = m.getGauge(nwBytesUsagePeakGaugeName);
        this.jvmMemoryUsedGauge = m.getGauge(jvmMemoryUsedGaugeName);
        this.jvmMemoryMaxGauge = m.getGauge(jvmMemoryMaxGaugeName);
    }

    private long getNextDelay() {
        if (this.counter.get() >= this.reportingIntervals.length) {
            return this.reportingIntervals[this.reportingIntervals.length - 1];
        }
        return this.reportingIntervals[this.counter.getAndIncrement()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPayloadAndMetrics() {
        block8: {
            long delay = this.getNextDelay();
            try {
                StatusPayloads.ResourceUsage usage = this.evalResourceUsage();
                if (usage == null) break block8;
                try {
                    this.heartbeat.addSingleUsePayload("" + StatusPayloads.Type.ResourceUsage, this.objectMapper.writeValueAsString((Object)usage));
                }
                catch (JsonProcessingException e) {
                    logger.warn("Error writing json for resourceUsage payload: " + e.getMessage());
                }
                this.cpuLimitGauge.set(Math.round(usage.getCpuLimit() * 100.0));
                this.cpuUsageCurrGauge.set(Math.round(usage.getCpuUsageCurrent() * 100.0));
                this.cpuUsagePeakGauge.set(Math.round(usage.getCpuUsagePeak() * 100.0));
                this.memLimitGauge.set(Math.round(usage.getMemLimit()));
                this.cachedMemUsageCurrGauge.set(Math.round(usage.getMemCacheCurrent()));
                this.cachedMemUsagePeakGauge.set(Math.round(usage.getMemCachePeak()));
                this.totMemUsageCurrGauge.set(Math.round(usage.getTotMemUsageCurrent()));
                this.totMemUsagePeakGauge.set(Math.round(usage.getTotMemUsagePeak()));
                this.nwBytesLimitGauge.set(Math.round(this.nwBytesLimit));
                this.nwBytesUsageCurrGauge.set(Math.round(usage.getNwBytesCurrent()));
                this.nwBytesUsagePeakGauge.set(Math.round(usage.getNwBytesPeak()));
                this.jvmMemoryUsedGauge.set(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
                this.jvmMemoryMaxGauge.set(Runtime.getRuntime().maxMemory());
                if (this.isBigIncrease(this.oldUsage, usage) || this.closeToLimit(usage)) {
                    delay = Math.min(delay, 10L);
                }
                this.oldUsage = usage;
            }
            catch (Exception e) {
                logger.error("Failed to compute resource usage", (Throwable)e);
            }
            finally {
                logger.debug("scheduling next metrics report with delay=" + delay);
                this.executor.schedule(this::setPayloadAndMetrics, delay, TimeUnit.SECONDS);
            }
        }
    }

    private boolean closeToLimit(StatusPayloads.ResourceUsage usage) {
        if (usage == null) {
            return false;
        }
        if (usage.getCpuUsageCurrent() / usage.getCpuLimit() > 0.9) {
            return true;
        }
        if (usage.getTotMemUsageCurrent() / usage.getMemLimit() > 0.9) {
            return true;
        }
        return usage.getNwBytesCurrent() / this.nwBytesLimit > 0.9;
    }

    private boolean isBigIncrease(StatusPayloads.ResourceUsage oldUsage, StatusPayloads.ResourceUsage newUsage) {
        if (oldUsage == null || newUsage == null) {
            return true;
        }
        if (this.isBigIncrease(oldUsage.getCpuUsageCurrent(), newUsage.getCpuUsageCurrent())) {
            return true;
        }
        if (this.isBigIncrease(oldUsage.getTotMemUsageCurrent(), newUsage.getTotMemUsageCurrent())) {
            return true;
        }
        return this.isBigIncrease(oldUsage.getNwBytesCurrent(), newUsage.getNwBytesCurrent());
    }

    private boolean isBigIncrease(double old, double curr) {
        if (old == 0.0) {
            return curr != 0.0;
        }
        return (curr - old) / old > 0.05;
    }

    void start(long intervalSecs) {
        this.executor.schedule(this::setPayloadAndMetrics, this.getNextDelay(), TimeUnit.SECONDS);
    }

    @Override
    public void close() throws IOException {
        this.executor.shutdownNow();
    }

    private StatusPayloads.ResourceUsage evalResourceUsage() throws IOException {
        double memCache;
        Usage usage = this.resourceUsageUtils.get();
        if (this.prevStatsGatheredAt == 0L) {
            this.setPreviousStats(usage);
            return null;
        }
        double elapsedInSecs = ((double)System.currentTimeMillis() - (double)this.prevStatsGatheredAt) / 1000.0;
        double cpuUsage = (usage.getCpusSystemTimeSecs() - this.prev_cpus_system_time_secs) / elapsedInSecs + (usage.getCpusUserTimeSecs() - this.prev_cpus_user_time_secs) / elapsedInSecs;
        if (cpuUsage > this.peakCpuUsage) {
            this.peakCpuUsage = cpuUsage;
        }
        if (cpuUsage > usage.getCpusLimit()) {
            logger.warn("CPU usage {} greater than limit {}, usage={}, elapsedInSecs={}", new Object[]{cpuUsage, usage.getCpusLimit(), usage, elapsedInSecs});
        }
        if (usage.getMemRssBytes() > this.peakTotMem) {
            this.peakTotMem = usage.getMemRssBytes();
        }
        if ((memCache = Math.max(0.0, usage.getMemRssBytes() - usage.getMemAnonBytes())) > this.peakMemCache) {
            this.peakMemCache = memCache;
        }
        double readBw = (usage.getNetworkReadBytes() - this.prev_bytes_read) / elapsedInSecs;
        double writeBw = (usage.getNetworkWriteBytes() - this.prev_bytes_written) / elapsedInSecs;
        if (readBw > this.peakBytesRead) {
            this.peakBytesRead = readBw;
        }
        if (writeBw > this.peakBytesWritten) {
            this.peakBytesWritten = writeBw;
        }
        this.setPreviousStats(usage);
        return new StatusPayloads.ResourceUsage(usage.getCpusLimit(), cpuUsage, this.peakCpuUsage, StorageUnit.BYTES.toMBs(usage.getMemLimit()), StorageUnit.BYTES.toMBs(memCache), StorageUnit.BYTES.toMBs(this.peakMemCache), StorageUnit.BYTES.toMBs(usage.getMemRssBytes()), StorageUnit.BYTES.toMBs(this.peakTotMem), Math.max(readBw, writeBw), Math.max(this.peakBytesRead, this.peakBytesWritten));
    }

    private void setPreviousStats(Usage usage) {
        this.prev_cpus_system_time_secs = usage.getCpusSystemTimeSecs();
        this.prev_cpus_user_time_secs = usage.getCpusUserTimeSecs();
        this.prev_bytes_read = usage.getNetworkReadBytes();
        this.prev_bytes_written = usage.getNetworkWriteBytes();
        this.prevStatsGatheredAt = System.currentTimeMillis();
    }
}

