/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.worker.jobmaster.control;

import io.mantisrx.server.worker.jobmaster.JobAutoScaler;
import io.mantisrx.server.worker.jobmaster.control.AdaptiveAutoscalerConfig;
import io.mantisrx.server.worker.jobmaster.control.actuators.MantisStageActuator;
import io.mantisrx.server.worker.jobmaster.control.controllers.PIDController;
import io.mantisrx.server.worker.jobmaster.control.utils.ErrorComputer;
import io.mantisrx.server.worker.jobmaster.control.utils.Integrator;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class AdaptiveAutoscaler
implements Observable.Transformer<JobAutoScaler.Event, Object> {
    private static Logger logger = LoggerFactory.getLogger(AdaptiveAutoscaler.class);
    private final AdaptiveAutoscalerConfig config;
    private final JobAutoScaler.StageScaler scaler;
    private final long initialSize;
    private final AtomicLong targetScale = new AtomicLong(0L);

    public AdaptiveAutoscaler(AdaptiveAutoscalerConfig config, JobAutoScaler.StageScaler scaler, int initialSize) {
        this.config = config;
        this.scaler = scaler;
        this.initialSize = initialSize;
        this.targetScale.set(initialSize);
    }

    public Observable<Object> call(Observable<JobAutoScaler.Event> metrics) {
        return metrics.filter(metric -> (long)metric.getNumWorkers() == this.targetScale.get()).map(JobAutoScaler.Event::getValue).lift((Observable.Operator)new ErrorComputer(this.config.setPoint, this.config.invert, this.config.rope)).lift((Observable.Operator)PIDController.of(this.config.kp, this.config.ki, this.config.kd)).lift((Observable.Operator)new Integrator(this.initialSize, this.config.minScale, this.config.maxScale)).lift((Observable.Operator)new MantisStageActuator(this.initialSize, this.scaler)).map(Math::round).doOnNext(this.targetScale::set).map(x -> x);
    }
}

