/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.worker.jobmaster.clutch;

import io.vavr.Tuple2;
import java.beans.ConstructorProperties;

public class ClutchPIDConfig {
    public final double setPoint;
    public final Tuple2<Double, Double> rope;
    public final double kp;
    public final double kd;

    @ConstructorProperties(value={"setPoint", "rope", "kp", "kd"})
    public ClutchPIDConfig(double setPoint, Tuple2<Double, Double> rope, double kp, double kd) {
        this.setPoint = setPoint;
        this.rope = rope;
        this.kp = kp;
        this.kd = kd;
    }

    public double getSetPoint() {
        return this.setPoint;
    }

    public Tuple2<Double, Double> getRope() {
        return this.rope;
    }

    public double getKp() {
        return this.kp;
    }

    public double getKd() {
        return this.kd;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClutchPIDConfig)) {
            return false;
        }
        ClutchPIDConfig other = (ClutchPIDConfig)o;
        if (Double.compare(this.getSetPoint(), other.getSetPoint()) != 0) {
            return false;
        }
        Tuple2<Double, Double> this$rope = this.getRope();
        Tuple2<Double, Double> other$rope = other.getRope();
        if (this$rope == null ? other$rope != null : !this$rope.equals(other$rope)) {
            return false;
        }
        if (Double.compare(this.getKp(), other.getKp()) != 0) {
            return false;
        }
        return Double.compare(this.getKd(), other.getKd()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $setPoint = Double.doubleToLongBits(this.getSetPoint());
        result = result * 59 + (int)($setPoint >>> 32 ^ $setPoint);
        Tuple2<Double, Double> $rope = this.getRope();
        result = result * 59 + ($rope == null ? 43 : $rope.hashCode());
        long $kp = Double.doubleToLongBits(this.getKp());
        result = result * 59 + (int)($kp >>> 32 ^ $kp);
        long $kd = Double.doubleToLongBits(this.getKd());
        result = result * 59 + (int)($kd >>> 32 ^ $kd);
        return result;
    }

    public String toString() {
        return "ClutchPIDConfig(setPoint=" + this.getSetPoint() + ", rope=" + this.getRope() + ", kp=" + this.getKp() + ", kd=" + this.getKd() + ")";
    }
}

