/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.worker.jobmaster.clutch;

import io.mantisrx.server.worker.jobmaster.clutch.ClutchPIDConfig;
import io.mantisrx.server.worker.jobmaster.clutch.rps.ClutchRpsPIDConfig;
import io.vavr.control.Option;
import java.beans.ConstructorProperties;

public class ClutchConfiguration {
    public final int minSize;
    public final int maxSize;
    public final double rps;
    public final Option<Long> minSamples;
    public final Option<Long> cooldownSeconds;
    public final Option<Double> panicThresholdSeconds;
    public final Option<Double> maxAdjustment;
    public final Option<Boolean> useExperimental;
    public final Option<Double> integralDecay;
    public final Option<ClutchPIDConfig> cpu;
    public final Option<ClutchPIDConfig> memory;
    public final Option<ClutchPIDConfig> network;
    public final Option<ClutchRpsPIDConfig> rpsConfig;

    @ConstructorProperties(value={"minSize", "maxSize", "rps", "minSamples", "cooldownSeconds", "panicThresholdSeconds", "maxAdjustment", "cpu", "memory", "network", "rpsConfig", "useExperimental", "integralDecay"})
    public ClutchConfiguration(int minSize, int maxSize, double rps, Option<Long> minSamples, Option<Long> cooldownSeconds, Option<Double> panicThresholdSeconds, Option<Double> maxAdjustment, Option<ClutchPIDConfig> cpu, Option<ClutchPIDConfig> memory, Option<ClutchPIDConfig> network, Option<ClutchRpsPIDConfig> rpsConfig, Option<Boolean> useExperimental, Option<Double> integralDecay) {
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.rps = rps;
        this.minSamples = minSamples;
        this.cooldownSeconds = cooldownSeconds;
        this.panicThresholdSeconds = panicThresholdSeconds;
        this.maxAdjustment = maxAdjustment;
        this.cpu = cpu;
        this.memory = memory;
        this.network = network;
        this.rpsConfig = rpsConfig;
        this.useExperimental = useExperimental;
        this.integralDecay = integralDecay;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public double getRps() {
        return this.rps;
    }

    public Option<Long> getMinSamples() {
        return this.minSamples;
    }

    public Option<Long> getCooldownSeconds() {
        return this.cooldownSeconds;
    }

    public Option<Double> getPanicThresholdSeconds() {
        return this.panicThresholdSeconds;
    }

    public Option<Double> getMaxAdjustment() {
        return this.maxAdjustment;
    }

    public Option<Boolean> getUseExperimental() {
        return this.useExperimental;
    }

    public Option<Double> getIntegralDecay() {
        return this.integralDecay;
    }

    public Option<ClutchPIDConfig> getCpu() {
        return this.cpu;
    }

    public Option<ClutchPIDConfig> getMemory() {
        return this.memory;
    }

    public Option<ClutchPIDConfig> getNetwork() {
        return this.network;
    }

    public Option<ClutchRpsPIDConfig> getRpsConfig() {
        return this.rpsConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClutchConfiguration)) {
            return false;
        }
        ClutchConfiguration other = (ClutchConfiguration)o;
        if (this.getMinSize() != other.getMinSize()) {
            return false;
        }
        if (this.getMaxSize() != other.getMaxSize()) {
            return false;
        }
        if (Double.compare(this.getRps(), other.getRps()) != 0) {
            return false;
        }
        Option<Long> this$minSamples = this.getMinSamples();
        Option<Long> other$minSamples = other.getMinSamples();
        if (this$minSamples == null ? other$minSamples != null : !this$minSamples.equals(other$minSamples)) {
            return false;
        }
        Option<Long> this$cooldownSeconds = this.getCooldownSeconds();
        Option<Long> other$cooldownSeconds = other.getCooldownSeconds();
        if (this$cooldownSeconds == null ? other$cooldownSeconds != null : !this$cooldownSeconds.equals(other$cooldownSeconds)) {
            return false;
        }
        Option<Double> this$panicThresholdSeconds = this.getPanicThresholdSeconds();
        Option<Double> other$panicThresholdSeconds = other.getPanicThresholdSeconds();
        if (this$panicThresholdSeconds == null ? other$panicThresholdSeconds != null : !this$panicThresholdSeconds.equals(other$panicThresholdSeconds)) {
            return false;
        }
        Option<Double> this$maxAdjustment = this.getMaxAdjustment();
        Option<Double> other$maxAdjustment = other.getMaxAdjustment();
        if (this$maxAdjustment == null ? other$maxAdjustment != null : !this$maxAdjustment.equals(other$maxAdjustment)) {
            return false;
        }
        Option<ClutchPIDConfig> this$cpu = this.getCpu();
        Option<ClutchPIDConfig> other$cpu = other.getCpu();
        if (this$cpu == null ? other$cpu != null : !this$cpu.equals(other$cpu)) {
            return false;
        }
        Option<ClutchPIDConfig> this$memory = this.getMemory();
        Option<ClutchPIDConfig> other$memory = other.getMemory();
        if (this$memory == null ? other$memory != null : !this$memory.equals(other$memory)) {
            return false;
        }
        Option<ClutchPIDConfig> this$network = this.getNetwork();
        Option<ClutchPIDConfig> other$network = other.getNetwork();
        if (this$network == null ? other$network != null : !this$network.equals(other$network)) {
            return false;
        }
        Option<ClutchRpsPIDConfig> this$rpsConfig = this.getRpsConfig();
        Option<ClutchRpsPIDConfig> other$rpsConfig = other.getRpsConfig();
        if (this$rpsConfig == null ? other$rpsConfig != null : !this$rpsConfig.equals(other$rpsConfig)) {
            return false;
        }
        Option<Boolean> this$useExperimental = this.getUseExperimental();
        Option<Boolean> other$useExperimental = other.getUseExperimental();
        if (this$useExperimental == null ? other$useExperimental != null : !this$useExperimental.equals(other$useExperimental)) {
            return false;
        }
        Option<Double> this$integralDecay = this.getIntegralDecay();
        Option<Double> other$integralDecay = other.getIntegralDecay();
        return !(this$integralDecay == null ? other$integralDecay != null : !this$integralDecay.equals(other$integralDecay));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMinSize();
        result = result * 59 + this.getMaxSize();
        long $rps = Double.doubleToLongBits(this.getRps());
        result = result * 59 + (int)($rps >>> 32 ^ $rps);
        Option<Long> $minSamples = this.getMinSamples();
        result = result * 59 + ($minSamples == null ? 43 : $minSamples.hashCode());
        Option<Long> $cooldownSeconds = this.getCooldownSeconds();
        result = result * 59 + ($cooldownSeconds == null ? 43 : $cooldownSeconds.hashCode());
        Option<Double> $panicThresholdSeconds = this.getPanicThresholdSeconds();
        result = result * 59 + ($panicThresholdSeconds == null ? 43 : $panicThresholdSeconds.hashCode());
        Option<Double> $maxAdjustment = this.getMaxAdjustment();
        result = result * 59 + ($maxAdjustment == null ? 43 : $maxAdjustment.hashCode());
        Option<ClutchPIDConfig> $cpu = this.getCpu();
        result = result * 59 + ($cpu == null ? 43 : $cpu.hashCode());
        Option<ClutchPIDConfig> $memory = this.getMemory();
        result = result * 59 + ($memory == null ? 43 : $memory.hashCode());
        Option<ClutchPIDConfig> $network = this.getNetwork();
        result = result * 59 + ($network == null ? 43 : $network.hashCode());
        Option<ClutchRpsPIDConfig> $rpsConfig = this.getRpsConfig();
        result = result * 59 + ($rpsConfig == null ? 43 : $rpsConfig.hashCode());
        Option<Boolean> $useExperimental = this.getUseExperimental();
        result = result * 59 + ($useExperimental == null ? 43 : $useExperimental.hashCode());
        Option<Double> $integralDecay = this.getIntegralDecay();
        result = result * 59 + ($integralDecay == null ? 43 : $integralDecay.hashCode());
        return result;
    }

    public String toString() {
        return "ClutchConfiguration(minSize=" + this.getMinSize() + ", maxSize=" + this.getMaxSize() + ", rps=" + this.getRps() + ", minSamples=" + this.getMinSamples() + ", cooldownSeconds=" + this.getCooldownSeconds() + ", panicThresholdSeconds=" + this.getPanicThresholdSeconds() + ", maxAdjustment=" + this.getMaxAdjustment() + ", cpu=" + this.getCpu() + ", memory=" + this.getMemory() + ", network=" + this.getNetwork() + ", rpsConfig=" + this.getRpsConfig() + ", useExperimental=" + this.getUseExperimental() + ", integralDecay=" + this.getIntegralDecay() + ")";
    }
}

