/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.worker;

import io.mantisrx.runtime.Context;
import io.mantisrx.runtime.Job;
import io.mantisrx.runtime.MantisJobState;
import io.mantisrx.runtime.StageConfig;
import io.mantisrx.runtime.WorkerInfo;
import io.mantisrx.runtime.descriptor.SchedulingInfo;
import io.mantisrx.runtime.descriptor.StageSchedulingInfo;
import io.mantisrx.server.core.JobSchedulingInfo;
import io.mantisrx.server.core.Status;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Observer;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.subjects.PublishSubject;

public class RunningWorker {
    private static final Logger logger = LoggerFactory.getLogger(RunningWorker.class);
    private final int totalStagesNet;
    private Action0 onTerminateCallback;
    private Action0 onCompleteCallback;
    private Action1<Throwable> onErrorCallback;
    private CountDownLatch blockUntilTerminate = new CountDownLatch(1);
    private Job job;
    private SchedulingInfo schedulingInfo;
    private StageConfig stage;
    private Observer<Status> jobStatus;
    private String jobId;
    private final int stageNum;
    private final int workerNum;
    private final int workerIndex;
    private final String jobName;
    private final int totalStages;
    private final int metricsPort;
    private final Observable<Integer> stageTotalWorkersObservable;
    private final Observable<JobSchedulingInfo> jobSchedulingInfoObservable;
    private final Iterator<Integer> ports;
    private final PublishSubject<Boolean> requestSubject;
    private Context context;
    private final WorkerInfo workerInfo;

    public RunningWorker(Builder builder) {
        this.workerInfo = builder.workerInfo;
        this.requestSubject = builder.requestSubject;
        this.job = builder.job;
        this.ports = builder.ports;
        this.metricsPort = builder.metricsPort;
        this.schedulingInfo = builder.schedulingInfo;
        this.stage = builder.stage;
        this.jobId = builder.jobId;
        this.stageNum = builder.stageNum;
        this.workerNum = builder.workerNum;
        this.workerIndex = builder.workerIndex;
        this.jobName = builder.jobName;
        this.totalStages = builder.totalStages;
        this.totalStagesNet = this.totalStages - (builder.hasJobMaster ? 1 : 0);
        this.jobStatus = builder.jobStatus;
        this.stageTotalWorkersObservable = builder.stageTotalWorkersObservable;
        this.jobSchedulingInfoObservable = builder.jobSchedulingInfoObservable;
        this.onTerminateCallback = new Action0(){

            public void call() {
                RunningWorker.this.blockUntilTerminate.countDown();
            }
        };
        this.onCompleteCallback = new Action0(){

            public void call() {
                logger.info("JobId: " + RunningWorker.this.jobId + " stage: " + RunningWorker.this.stageNum + ", completed");
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            1.sleep(3000L);
                            System.exit(1);
                        }
                        catch (Exception e) {
                            logger.error("Ignoring exception during exit: " + e.getMessage(), (Throwable)e);
                        }
                    }
                }.start();
                RunningWorker.this.signalCompleted();
            }
        };
        this.onErrorCallback = new Action1<Throwable>(){

            public void call(Throwable t) {
                RunningWorker.this.signalFailed(t);
            }
        };
    }

    public void signalStartedInitiated() {
        logger.info("JobId: " + this.jobId + ", stage: " + this.stageNum + " workerIndex: " + this.workerIndex + " workerNumber: " + this.workerNum + ", signaling started initiated");
        this.requestSubject.onNext((Object)true);
        this.requestSubject.onCompleted();
        this.jobStatus.onNext((Object)new Status(this.jobId, this.stageNum, this.workerIndex, this.workerNum, Status.TYPE.INFO, "Beginning job execution " + this.workerIndex, MantisJobState.StartInitiated));
    }

    public void signalStarted() {
        logger.info("JobId: " + this.jobId + ", " + String.format("stage %s worker index=%s number=%s %s", this.stageNum, this.workerIndex, this.workerNum, "signaling started"));
        this.jobStatus.onNext((Object)new Status(this.jobId, this.stageNum, this.workerIndex, this.workerNum, Status.TYPE.INFO, String.format("stage %s worker index=%s number=%s %s", this.stageNum, this.workerIndex, this.workerNum, "running"), MantisJobState.Started));
    }

    public void signalCompleted() {
        logger.info("JobId: " + this.jobId + ", stage: " + this.stageNum + " workerIndex: " + this.workerIndex + " workerNumber: " + this.workerNum + ", signaling completed");
        this.jobStatus.onNext((Object)new Status(this.jobId, this.stageNum, this.workerIndex, this.workerNum, Status.TYPE.INFO, String.format("stage %s worker index=%s number=%s %s", this.stageNum, this.workerIndex, this.workerNum, "completed"), MantisJobState.Completed));
        this.jobStatus.onCompleted();
    }

    public void signalFailed(Throwable t) {
        logger.info("JobId: " + this.jobId + ", stage: " + this.stageNum + " workerIndex: " + this.workerIndex + " workerNumber: " + this.workerNum + ", signaling failed");
        logger.error("Worker failure detected, shutting down job", t);
        this.jobStatus.onNext((Object)new Status(this.jobId, this.stageNum, this.workerIndex, this.workerNum, Status.TYPE.INFO, String.format("stage %s worker index=%s number=%s %s", this.stageNum, this.workerIndex, this.workerNum, "failed. error: " + t.getMessage()), MantisJobState.Failed));
    }

    public void waitUntilTerminate() {
        try {
            this.blockUntilTerminate.await();
        }
        catch (InterruptedException e) {
            logger.error("Thread interrupted during await call", (Throwable)e);
        }
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public WorkerInfo getWorkerInfo() {
        return this.workerInfo;
    }

    public StageSchedulingInfo stageSchedulingInfo(int stageNum) {
        return this.schedulingInfo.forStage(stageNum);
    }

    public StageSchedulingInfo stageSchedulingInfo() {
        return this.schedulingInfo.forStage(this.stageNum);
    }

    public Observable<Integer> getSourceStageTotalWorkersObservable() {
        return this.stageTotalWorkersObservable;
    }

    public Observable<JobSchedulingInfo> getJobSchedulingInfoObservable() {
        return this.jobSchedulingInfoObservable;
    }

    public Job getJob() {
        return this.job;
    }

    public Iterator<Integer> getPorts() {
        return this.ports;
    }

    public int getMetricsPort() {
        return this.metricsPort;
    }

    public StageConfig getStage() {
        return this.stage;
    }

    public SchedulingInfo getSchedulingInfo() {
        return this.schedulingInfo;
    }

    public Action0 getOnTerminateCallback() {
        return this.onTerminateCallback;
    }

    public Action0 getOnCompleteCallback() {
        return this.onCompleteCallback;
    }

    public Action1<Throwable> getOnErrorCallback() {
        return this.onErrorCallback;
    }

    public Observer<Status> getJobStatus() {
        return this.jobStatus;
    }

    public String getJobId() {
        return this.jobId;
    }

    public int getStageNum() {
        return this.stageNum;
    }

    public int getWorkerNum() {
        return this.workerNum;
    }

    public int getWorkerIndex() {
        return this.workerIndex;
    }

    public String getJobName() {
        return this.jobName;
    }

    public int getTotalStagesNet() {
        return this.totalStagesNet;
    }

    public String toString() {
        return "RunningWorker [" + this.job + ", schedulingInfo=" + this.schedulingInfo + ", stage=" + this.stage + ", jobStatus=" + this.jobStatus + ", jobId=" + this.jobId + ", stageNum=" + this.stageNum + ", workerNum=" + this.workerNum + ", workerIndex=" + this.workerIndex + ", jobName=" + this.jobName + ", totalStages=" + this.totalStages + ", metricsPort=" + this.metricsPort + ", ports=" + this.ports + ", requestSubject=" + this.requestSubject + ", context=" + this.context + ", workerInfo=" + this.workerInfo + "]";
    }

    public static class Builder {
        private WorkerInfo workerInfo;
        private Job job;
        private Iterator<Integer> ports;
        private int metricsPort;
        private SchedulingInfo schedulingInfo;
        private StageConfig stage;
        private Observer<Status> jobStatus;
        private String jobId;
        private int stageNum;
        private int workerNum;
        private int workerIndex;
        private String jobName;
        private int totalStages;
        private Observable<Integer> stageTotalWorkersObservable;
        private Observable<JobSchedulingInfo> jobSchedulingInfoObservable;
        private PublishSubject<Boolean> requestSubject;
        private boolean hasJobMaster = false;

        public Builder workerInfo(WorkerInfo workerInfo) {
            this.workerInfo = workerInfo;
            return this;
        }

        public Builder ports(Iterator<Integer> ports) {
            this.ports = ports;
            return this;
        }

        public Builder job(Job job) {
            this.job = job;
            return this;
        }

        public Builder requestSubject(PublishSubject<Boolean> requestSubject) {
            this.requestSubject = requestSubject;
            return this;
        }

        public Builder stage(StageConfig stage) {
            this.stage = stage;
            return this;
        }

        public Builder schedulingInfo(SchedulingInfo schedulingInfo) {
            this.schedulingInfo = schedulingInfo;
            return this;
        }

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder jobStatusObserver(Observer<Status> jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        public Builder stageNum(int stageNum) {
            this.stageNum = stageNum;
            return this;
        }

        public Builder metricsPort(int metricsPort) {
            this.metricsPort = metricsPort;
            return this;
        }

        public Builder workerNum(int workerNum) {
            this.workerNum = workerNum;
            return this;
        }

        public Builder workerIndex(int workerIndex) {
            this.workerIndex = workerIndex;
            return this;
        }

        public Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public Builder totalStages(int totalStages) {
            this.totalStages = totalStages;
            return this;
        }

        public Builder hasJobMaster(boolean b) {
            this.hasJobMaster = b;
            return this;
        }

        public Builder stageTotalWorkersObservable(Observable<Integer> stageTotalWorkersObservable) {
            this.stageTotalWorkersObservable = stageTotalWorkersObservable;
            return this;
        }

        public Builder jobSchedulingInfoObservable(Observable<JobSchedulingInfo> jobSchedulingInfoObservable) {
            this.jobSchedulingInfoObservable = jobSchedulingInfoObservable;
            return this;
        }

        public RunningWorker build() {
            return new RunningWorker(this);
        }
    }
}

