/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.worker.jobmaster.control.actuators;

import com.netflix.control.IActuator;
import io.mantisrx.server.worker.jobmaster.JobAutoScaler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MantisStageActuator
extends IActuator {
    private static Logger logger = LoggerFactory.getLogger(MantisStageActuator.class);
    private final JobAutoScaler.StageScaler scaler;
    private Long lastValue;

    public MantisStageActuator(long initialSize, JobAutoScaler.StageScaler scaler) {
        this.scaler = scaler;
        this.lastValue = initialSize;
    }

    protected Double processStep(Double input) {
        Long desiredNumWorkers = Double.valueOf(Math.ceil(input)).longValue();
        String reason = "Clutch determined " + desiredNumWorkers + " instance(s) for target resource usage.";
        if (desiredNumWorkers < this.lastValue) {
            this.scaler.scaleDownStage(this.lastValue.intValue(), desiredNumWorkers.intValue(), reason);
            this.lastValue = desiredNumWorkers;
        } else if (desiredNumWorkers > this.lastValue) {
            this.scaler.scaleUpStage(this.lastValue.intValue(), desiredNumWorkers.intValue(), reason);
            this.lastValue = desiredNumWorkers;
        }
        return (double)desiredNumWorkers.longValue() * 1.0;
    }
}

