/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.worker.jobmaster.clutch.rps;

import com.netflix.control.clutch.Clutch;
import com.yahoo.sketches.quantiles.UpdateDoublesSketch;
import io.mantisrx.runtime.descriptor.StageSchedulingInfo;
import io.mantisrx.server.worker.jobmaster.clutch.ClutchConfiguration;
import io.mantisrx.server.worker.jobmaster.clutch.rps.ClutchRpsPIDConfig;
import io.vavr.Function1;
import io.vavr.Tuple2;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class RpsClutchConfigurationSelector
implements Function1<Map<Clutch.Metric, UpdateDoublesSketch>, com.netflix.control.clutch.ClutchConfiguration> {
    private static final double DEFAULT_INTEGRAL_DECAY = 0.1;
    private final Integer stageNumber;
    private final StageSchedulingInfo stageSchedulingInfo;
    private final ClutchConfiguration customConfig;
    private com.netflix.control.clutch.ClutchConfiguration prevConfig;

    public RpsClutchConfigurationSelector(Integer stageNumber, StageSchedulingInfo stageSchedulingInfo, ClutchConfiguration customConfig) {
        this.stageNumber = stageNumber;
        this.stageSchedulingInfo = stageSchedulingInfo;
        this.customConfig = customConfig;
    }

    public com.netflix.control.clutch.ClutchConfiguration apply(Map<Clutch.Metric, UpdateDoublesSketch> sketches) {
        double setPoint = this.getSetpoint(sketches);
        Tuple2 rope = this.getRope().map(x -> x / 100.0 * setPoint, y -> y / 100.0 * setPoint);
        long deltaT = this.getCooldownSecs() / 30L;
        double kp = 1.0 / Math.max(setPoint, 1.0) / Math.max(this.getCumulativeIntegralDivisor(this.getIntegralScaler(), deltaT), 1.0);
        double ki = 0.0;
        double kd = 1.0 / Math.max(setPoint, 1.0) / Math.max(this.getCumulativeIntegralDivisor(this.getIntegralScaler(), deltaT), 1.0);
        com.netflix.control.clutch.ClutchConfiguration config = com.netflix.control.clutch.ClutchConfiguration.builder().metric(Clutch.Metric.RPS).setPoint(setPoint).kp(kp).ki(ki).kd(kd).integralDecay(this.getIntegralScaler()).minSize(this.getMinSize()).maxSize(this.getMaxSize()).rope(rope).cooldownInterval(this.getCooldownSecs()).cooldownUnits(TimeUnit.SECONDS).build();
        if (this.isSimilarToPreviousConfig(config)) {
            return this.prevConfig;
        }
        this.prevConfig = config;
        return config;
    }

    private double getSetpoint(Map<Clutch.Metric, UpdateDoublesSketch> sketches) {
        UpdateDoublesSketch rpsSketch = sketches.get(Clutch.Metric.RPS);
        double setPoint = rpsSketch.getQuantile(this.getSetPointPercentile());
        if (rpsSketch.getQuantile(0.99) * this.getSetPointPercentile() > setPoint) {
            setPoint *= 1.1;
        }
        return setPoint;
    }

    private double getSetPointPercentile() {
        if (this.customConfig != null && this.customConfig.getRpsConfig().isDefined()) {
            return ((ClutchRpsPIDConfig)this.customConfig.getRpsConfig().get()).getSetPointPercentile() / 100.0;
        }
        return ClutchRpsPIDConfig.DEFAULT.getSetPointPercentile() / 100.0;
    }

    private Tuple2<Double, Double> getRope() {
        if (this.customConfig != null && this.customConfig.getRpsConfig().isDefined()) {
            return ((ClutchRpsPIDConfig)this.customConfig.getRpsConfig().get()).getRope();
        }
        return ClutchRpsPIDConfig.DEFAULT.getRope();
    }

    private int getMinSize() {
        if (this.customConfig != null && this.customConfig.getMinSize() > 0) {
            return this.customConfig.getMinSize();
        }
        if (this.stageSchedulingInfo.getScalingPolicy() != null && this.stageSchedulingInfo.getScalingPolicy().getMin() > 0) {
            return this.stageSchedulingInfo.getScalingPolicy().getMin();
        }
        return this.stageSchedulingInfo.getNumberOfInstances();
    }

    private int getMaxSize() {
        if (this.customConfig != null && this.customConfig.getMaxSize() > 0) {
            return this.customConfig.getMaxSize();
        }
        if (this.stageSchedulingInfo.getScalingPolicy() != null && this.stageSchedulingInfo.getScalingPolicy().getMax() > 0) {
            return this.stageSchedulingInfo.getScalingPolicy().getMax();
        }
        return this.stageSchedulingInfo.getNumberOfInstances();
    }

    private long getCooldownSecs() {
        if (this.customConfig != null && this.customConfig.getCooldownSeconds().isDefined()) {
            return (Long)this.customConfig.getCooldownSeconds().get();
        }
        if (this.stageSchedulingInfo.getScalingPolicy() != null) {
            return this.stageSchedulingInfo.getScalingPolicy().getCoolDownSecs();
        }
        return 0L;
    }

    private double getIntegralScaler() {
        if (this.customConfig != null && this.customConfig.getIntegralDecay().isDefined()) {
            return 1.0 - (Double)this.customConfig.getIntegralDecay().get();
        }
        return 0.9;
    }

    private boolean isSimilarToPreviousConfig(com.netflix.control.clutch.ClutchConfiguration curConfig) {
        if (this.prevConfig == null) {
            return false;
        }
        double prevSetPoint = this.prevConfig.getSetPoint();
        double curSetPoint = curConfig.getSetPoint();
        return curSetPoint >= prevSetPoint * 0.95 && curSetPoint <= prevSetPoint * 1.05;
    }

    private double getCumulativeIntegralDivisor(double integralScaler, long count) {
        double result = 0.0;
        int i = 0;
        while ((long)i < count) {
            result = result * integralScaler + 1.0;
            ++i;
        }
        return result;
    }
}

