/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.worker.jobmaster;

import io.mantisrx.runtime.descriptor.StageScalingPolicy;
import io.mantisrx.runtime.descriptor.StageSchedulingInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final Logger log = LoggerFactory.getLogger(Util.class);

    public static double getEffectiveValue(StageSchedulingInfo stageSchedulingInfo, StageScalingPolicy.ScalingReason type, double value) {
        switch (type) {
            case CPU: {
                return 100.0 * value / stageSchedulingInfo.getMachineDefinition().getCpuCores();
            }
            case Memory: {
                return 100.0 * value / stageSchedulingInfo.getMachineDefinition().getMemoryMB();
            }
            case JVMMemory: {
                return 100.0 * (value / stageSchedulingInfo.getMachineDefinition().getMemoryMB());
            }
            case DataDrop: 
            case KafkaLag: 
            case UserDefined: 
            case KafkaProcessed: {
                return value;
            }
            case Network: {
                return 100.0 * value * 8.0 / (1048576.0 * stageSchedulingInfo.getMachineDefinition().getNetworkMbps());
            }
        }
        return value;
    }
}

