/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.worker.jobmaster;

import io.mantisrx.common.MantisServerSentEvent;
import io.mantisrx.runtime.parameter.SourceJobParameters;
import io.mantisrx.server.core.NamedJobInfo;
import io.mantisrx.server.master.client.MantisMasterGateway;
import io.mantisrx.server.worker.client.WorkerMetricsClient;
import io.mantisrx.server.worker.jobmaster.AutoScaleMetricsConfig;
import io.mantisrx.server.worker.jobmaster.WorkerMetricSubscription;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class SourceJobWorkerMetricsSubscription {
    private static final Logger logger = LoggerFactory.getLogger(SourceJobWorkerMetricsSubscription.class);
    private final List<SourceJobParameters.TargetInfo> targetInfos;
    private final MantisMasterGateway masterClient;
    private final WorkerMetricsClient workerMetricsClient;
    private final AutoScaleMetricsConfig metricsConfig;

    public SourceJobWorkerMetricsSubscription(List<SourceJobParameters.TargetInfo> targetInfos, MantisMasterGateway masterClient, WorkerMetricsClient workerMetricsClient, AutoScaleMetricsConfig metricsConfig) {
        this.targetInfos = targetInfos;
        this.masterClient = masterClient;
        this.workerMetricsClient = workerMetricsClient;
        this.metricsConfig = metricsConfig;
    }

    public Observable<Observable<MantisServerSentEvent>> getResults() {
        return Observable.merge((Iterable)this.getSourceJobToClientMap().entrySet().stream().map(entry -> {
            String sourceJobName = (String)entry.getKey();
            Set clientIds = (Set)entry.getValue();
            Set<String> sourceJobMetrics = this.metricsConfig.generateSourceJobMetricGroups(clientIds);
            return this.masterClient.namedJobInfo(sourceJobName).map(NamedJobInfo::getJobId).flatMap(jobId -> this.getResultsForJobId((String)jobId, sourceJobMetrics));
        }).collect(Collectors.toList()));
    }

    protected Observable<Observable<MantisServerSentEvent>> getResultsForJobId(String jobId, Set<String> sourceJobMetrics) {
        return new WorkerMetricSubscription(jobId, this.workerMetricsClient, sourceJobMetrics).getMetricsClient().getResults();
    }

    protected Map<String, Set<String>> getSourceJobToClientMap() {
        HashMap<String, Set<String>> results = new HashMap<String, Set<String>>();
        for (SourceJobParameters.TargetInfo info : this.targetInfos) {
            HashSet<String> clientIds = (HashSet<String>)results.get(info.sourceJobName);
            if (clientIds == null) {
                clientIds = new HashSet<String>();
                results.put(info.sourceJobName, clientIds);
            }
            clientIds.add(info.clientId);
        }
        return results;
    }
}

