/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.worker;

import com.mantisrx.common.utils.MantisMetricStringConstants;
import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Gauge;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import io.mantisrx.server.core.StatusPayloads;
import io.mantisrx.server.worker.Heartbeat;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.reactivx.mantis.operators.DropOperator;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataDroppedPayloadSetter
implements Closeable {
    private static final String metricNamePrefix = MantisMetricStringConstants.DROP_OPERATOR_INCOMING_METRIC_GROUP;
    private static final Logger logger = LoggerFactory.getLogger(DataDroppedPayloadSetter.class);
    private final Heartbeat heartbeat;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final ScheduledThreadPoolExecutor executor;
    private ScheduledFuture<?> future;
    private final Gauge dropCountGauge;
    private final Gauge onNextCountGauge;

    DataDroppedPayloadSetter(Heartbeat heartbeat) {
        this.heartbeat = heartbeat;
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.executor = new ScheduledThreadPoolExecutor(1);
        Metrics m = new Metrics.Builder().name("DataDrop").addGauge("dropCount").addGauge("onNextCount").build();
        m = MetricsRegistry.getInstance().registerAndGet(m);
        this.dropCountGauge = m.getGauge("dropCount");
        this.onNextCountGauge = m.getGauge("onNextCount");
    }

    protected void setPayload(long intervalSecs) {
        block9: {
            Collection metrics = MetricsRegistry.getInstance().getMetrics(metricNamePrefix);
            long totalDropped = 0L;
            long totalOnNext = 0L;
            try {
                if (metrics != null && !metrics.isEmpty()) {
                    for (Metrics m : metrics) {
                        Counter dropped = m.getCounter("" + DropOperator.Counters.dropped);
                        Counter onNext = m.getCounter("" + DropOperator.Counters.onNext);
                        if (dropped != null) {
                            totalDropped += dropped.value();
                        } else {
                            logger.warn("Unexpected to get null dropped counter for metric " + m.getMetricGroupId().id());
                        }
                        if (onNext != null) {
                            totalOnNext += onNext.value();
                            continue;
                        }
                        logger.warn("Unexpected to get null onNext counter for metric " + m.getMetricGroupId().id());
                    }
                    StatusPayloads.DataDropCounts dataDrop = new StatusPayloads.DataDropCounts(totalOnNext, totalDropped);
                    try {
                        this.heartbeat.addSingleUsePayload("" + StatusPayloads.Type.IncomingDataDrop, this.objectMapper.writeValueAsString((Object)dataDrop));
                    }
                    catch (JsonProcessingException e) {
                        logger.warn("Error writing json for dataDrop payload: " + e.getMessage());
                    }
                    this.dropCountGauge.set(dataDrop.getDroppedCount());
                    this.onNextCountGauge.set(dataDrop.getOnNextCount());
                    break block9;
                }
                logger.debug("Got no metrics from DropOperator");
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    void start(long intervalSecs) {
        this.future = this.executor.scheduleAtFixedRate(() -> this.setPayload(intervalSecs), intervalSecs, intervalSecs, TimeUnit.SECONDS);
    }

    @Override
    public void close() throws IOException {
        if (this.future != null) {
            this.future.cancel(false);
        }
        this.executor.shutdownNow();
    }
}

